import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type CardHeader from "./CardHeader.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-card</code> is a component that represents information in the form of a
 * tile with separate header and content areas.
 * The content area of a <code>ui5-card</code> can be arbitrary HTML content.
 * The header can be used through slot <code>header</code>. For which there is a <code>ui5-card-header</code> component to achieve the card look and feel.
 *
 * Note: We recommend the usage of <code>ui5-card-header</code> for the header slot, so advantage can be taken for keyboard handling, styling and accessibility.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Card";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/CardHeader.js";</code> (for <code>ui5-card-header</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Card
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-card
 * @public
 * @appenddocs sap.ui.webc.main.CardHeader
 */
declare class Card extends UI5Element {
    /**
     * Defines the accessible name of the component, which is used as the name of the card region and should be unique per card.
     * <b>Note:</b> <code>accessibleName</code> should be always set, unless <code>accessibleNameRef</code> is set.
     *
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.Card.prototype.accessibleName
     * @public
     * @since 1.0.0-rc.16
    */
    accessibleName: string;
    /**
     * Defines the IDs of the elements that label the component.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.Card.prototype.accessibleNameRef
     * @public
     * @since 1.0.0-rc.16
    */
    accessibleNameRef: string;
    /**
     * Defines the content of the component.
     * @type {HTMLElement[]}
     * @slot content
     * @name sap.ui.webc.main.Card.prototype.default
     * @public
    */
    content: Array<HTMLElement>;
    /**
     * Defines the header of the component.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-card-header</code> for the intended design.
     * @type {sap.ui.webc.main.ICardHeader[]}
     * @since 1.0.0-rc.15
     * @slot header
     * @name sap.ui.webc.main.Card.prototype.header
     * @public
    */
    header: Array<CardHeader>;
    static i18nBundle: I18nBundle;
    get classes(): {
        root: {
            "ui5-card-root": boolean;
            "ui5-card--interactive": boolean;
            "ui5-card--nocontent": boolean;
        };
    };
    get _hasHeader(): boolean;
    get _getAriaLabel(): string;
    get _ariaCardContentLabel(): string;
    static onDefine(): Promise<void>;
}
export default Card;
