import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-card-header</code> is a component, meant to be used as a header of the <code>ui5-card</code> component.
 * It displays valuable information, that can be defined with several properties, such as: <code>titleText</code>, <code>subtitleText</code>, <code>status</code>
 * and two slots: <code>avatar</code> and <code>action</code>.
 *
 * <h3>Keyboard handling</h3>
 * In case you enable <code>interactive</code> property, you can press the <code>ui5-card-header</code> by Space and Enter keys.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-card-header</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>root - Used to style the root DOM element of the CardHeader</li>
 * <li>title - Used to style the title of the CardHeader</li>
 * <li>subtitle - Used to style the subtitle of the CardHeader</li>
 * <li>status - Used to style the status of the CardHeader</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/CardHeader";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.CardHeader
 * @implements sap.ui.webc.main.ICardHeader
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-card-header
 * @public
 * @since 1.0.0-rc.15
 */
declare class CardHeader extends UI5Element {
    /**
     * Defines the title text.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.CardHeader.prototype.titleText
     * @public
    */
    titleText: string;
    /**
     * Defines the subtitle text.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.CardHeader.prototype.subtitleText
     * @public
    */
    subtitleText: string;
    /**
     * Defines the status text.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.CardHeader.prototype.status
     * @public
    */
    status: string;
    /**
     * Defines if the component would be interactive,
     * e.g gets hover effect, gets focus outline and <code>click</code> event is fired, when pressed.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.CardHeader.prototype.interactive
     * @public
    */
    interactive: boolean;
    /**
     * Define the <code>aria-level</code> attribute of the component
     * <b>Note: </b> If the interactive property is set, <code>aria-level</code> attribute is not rendered at all.
     * @private
     * @type {sap.ui.webc.base.types.Integer}
     * @defaultValue 3
    */
    _ariaLevel: number;
    _headerActive: boolean;
    /**
     * Defines an avatar image, displayed in the left most part of the header.
     * @type {HTMLElement[]}
     * @slot
     * @name sap.ui.webc.main.CardHeader.prototype.avatar
     * @public
    */
    avatar: Array<HTMLElement>;
    /**
     * Defines an action, displayed in the right most part of the header.
     * @type {HTMLElement[]}
     * @slot
     * @name sap.ui.webc.main.CardHeader.prototype.action
     * @public
    */
    action: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    get classes(): {
        root: {
            "ui5-card-header": boolean;
            "ui5-card-header--interactive": boolean;
            "ui5-card-header--active": boolean;
            "ui5-card-header-ff": boolean;
        };
    };
    get _root(): HTMLElement;
    get ariaRoleDescription(): string;
    get ariaRoleFocusableElement(): "button" | null;
    get ariaCardAvatarLabel(): string;
    get ariaLabelledBy(): string | undefined;
    get hasAvatar(): boolean;
    get hasAction(): boolean;
    static onDefine(): Promise<void>;
    _actionsFocusin(): void;
    _actionsFocusout(): void;
    _click(e: MouseEvent): void;
    _keydown(e: KeyboardEvent): void;
    _keyup(e: KeyboardEvent): void;
}
export default CardHeader;
