import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-color-palette-item</code> component represents a color in the the <code>ui5-color-palette</code>.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ColorPaletteItem
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-color-palette-item
 * @since 1.0.0-rc.12
 * @implements sap.ui.webc.main.IColorPaletteItem
 * @public
 */
declare class ColorPaletteItem extends UI5Element implements ITabbable {
    /**
     * Defines the colour of the component.
     * <br><br>
     * <b>Note:</b> The value should be a valid CSS color.
     *
     * @type {sap.ui.webc.base.types.CSSColor}
     * @name sap.ui.webc.main.ColorPaletteItem.prototype.value
     * @public
     */
    value: string;
    /**
     * Defines the tab-index of the element, helper information for the ItemNavigation.
     * @private
     */
    _tabIndex: string;
    /**
     * Defines the index of the item inside of the ColorPalette.
     * @private
     * @type {Integer}
     */
    index?: number;
    /**
     * Defines if the ColorPalette is on phone mode.
     * @private
     * @type {boolean}
     */
    phone: boolean;
    /**
     * @private
     * @type {boolean}
     * @since 1.0.0-rc.15
     */
    _disabled: boolean;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    get colorLabel(): string;
    get styles(): {
        root: {
            "background-color": string;
        };
    };
}
export default ColorPaletteItem;
