import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import "@ui5/webcomponents-icons/dist/date-time.js";
import type ResponsivePopover from "./ResponsivePopover.js";
import type { CalendarSelectedDatesChangeEventDetail } from "./Calendar.js";
import DatePicker from "./DatePicker.js";
import type { DatePickerChangeEventDetail as DateTimePickerChangeEventDetail, DatePickerInputEventDetail as DateTimePickerInputEventDetail } from "./DatePicker.js";
import type { TimeSelectionChangeEventDetail, TimeSelectionSliderChangeEventDetail } from "./TimeSelection.js";
import CalendarPickersMode from "./types/CalendarPickersMode.js";
type PreviewValues = {
    timeSelectionValue?: string;
    calendarTimestamp?: number;
    calendarValue?: string;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>DateTimePicker</code> component alows users to select both date (day, month and year) and time (hours, minutes and seconds)
 * and for the purpose it consists of input field and Date/Time picker.
 *
 * <h3>Usage</h3>
 *
 * Use the <code>DateTimePicker</code> if you need a combined date and time input component.
 * Don't use it if you want to use either date, or time value.
 * In this case, use the <code>DatePicker</code> or the <code>TimePicker</code> components instead.
 * <br><br>
 * The user can set date/time by:
 * <ul>
 * <li>using the calendar and the time selectors</li>
 * <li>typing in the input field</li>
 * </ul>
 *
 * Programmatically, to set date/time for the <code>DateTimePicker</code>, use the <code>value</code> property
 *
 * <h3>Formatting</h3>
 *
 * The value entered by typing into the input field must fit to the used date/time format.
 * <br><br>
 * Supported format options are pattern-based on Unicode LDML Date Format notation.
 * For more information, see <ui5-link target="_blank" href="https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table">UTS #35: Unicode Locale Data Markup Language</ui5-link>.
 * <br><br>
 * <b>Example:</b> the following format <code>dd/MM/yyyy, hh:mm:ss aa</code>
 * corresponds the <code>13/04/2020, 03:16:16 AM</code> value.
 * <br>
 * The small 'h' defines "12" hours format and the "aa" symbols - "AM/PM" time periods.
 *
 * <br><br>
 * <b>Example:</b> the following format <code>dd/MM/yyyy, HH:mm:ss</code>
 * corresponds the <code>13/04/2020, 15:16:16</code> value.
 * <br>
 * The capital 'H' indicates "24" hours format.
 *
 * <br><br>
 * <b>Note:</b> If the <code>formatPattern</code> does NOT include time,
 * the <code>DateTimePicker</code> will fallback to the default time format according to the locale.
 *
 * <br><br>
 * <b>Note:</b> If no placeholder is set to the <code>DateTimePicker</code>,
 * the current <code>formatPattern</code> is displayed as a placeholder.
 * If another placeholder is needed, it must be set or in case no placeholder is needed - it can be set to an empty string.
 *
 * <br><br>
 * <b>Note:</b> If the user input does NOT match the <code>formatPattern</code>,
 * the <code>DateTimePicker</code> makes an attempt to parse it based on the
 * locale settings.
 *
 * <h3>Responsive behavior</h3>
 *
 * The <code>DateTimePicker</code> is responsive and fully adapts to all devices.
 * For larger screens, such as tablet or desktop, it is displayed as a popover, while
 * on phone devices, it is displayed full screen.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/DateTimePicker.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.DateTimePicker
 * @extends sap.ui.webc.main.DatePicker
 * @tagname ui5-datetime-picker
 * @since 1.0.0-rc.7
 * @public
 */
declare class DateTimePicker extends DatePicker {
    /**
     * Defines the visibility of the time view in <code>phoneMode</code>.
     * For more information, see the <code>phoneMode</code> property.
     *
     * <br><br>
     * <b>Note:</b> The date view would be displayed by default.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _showTimeView: boolean;
    /**
     * Defines if the <code>DateTimePicker</code> should be displayed in phone mode.
     * The phone mode turns on when the component is used on small screens or phone devices.
     * In phone mode the user can see either the calendar view, or the time view
     * and can switch between the views via toggle buttons.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _phoneMode: boolean;
    /**
     * Selected, but not yet confirmed date/time
     * @private
     */
    _previewValues: PreviewValues;
    /**
     * @private
     */
    _currentTimeSlider: string;
    _handleResizeBound: ResizeObserverCallback;
    constructor();
    /**
     * @override
     */
    onResponsivePopoverAfterClose(): void;
    /**
     * LIFECYCLE METHODS
     */
    onEnterDOM(): void;
    onExitDOM(): void;
    /**
     * PUBLIC METHODS
     */
    /**
     * Opens the picker.
     * @public
     */
    openPicker(): Promise<void>;
    /**
     * Read-only getters
     */
    get classes(): {
        picker: {
            "ui5-dt-picker-content--phone": boolean;
        };
        dateTimeView: {
            "ui5-dt-cal--hidden": boolean;
            "ui5-dt-time--hidden": boolean;
        };
        footer: {
            "ui5-dt-picker-footer-time-hidden": boolean;
        };
    };
    get _formatPattern(): string;
    get _calendarTimestamp(): number;
    get _calendarSelectedDates(): string[];
    get _timeSelectionValue(): string;
    get openIconName(): string;
    get btnOKLabel(): string;
    get btnCancelLabel(): string;
    get btnDateLabel(): string;
    get btnTimeLabel(): string;
    get showFooter(): boolean;
    get showDateView(): boolean;
    get showTimeView(): boolean;
    get phone(): boolean;
    get dateAriaDescription(): string;
    /**
     * Defines whether the dialog on mobile should have header
     * @private
     */
    get _shouldHideHeader(): boolean;
    /**
     * EVENT HANDLERS
     */
    /**
     * @override
     */
    onSelectedDatesChange(e: CustomEvent<CalendarSelectedDatesChangeEventDetail>): void;
    onTimeSelectionChange(e: CustomEvent<TimeSelectionChangeEventDetail>): void;
    onTimeSliderChange(e: CustomEvent<TimeSelectionSliderChangeEventDetail>): void;
    /**
     * Handles document resize to switch between <code>phoneMode</code> and normal appearance.
     */
    _handleResize(): void;
    get _submitDisabled(): boolean;
    /**
     * Handles clicking on the <code>submit</code> button, within the picker`s footer.
     */
    _submitClick(): void;
    /**
     * Handles clicking on the <code>cancel</code> button, within the picker`s footer,
     * that would disregard the user selection.
     */
    _cancelClick(): void;
    /**
     * Handles the date/time switch available in <code>phoneMode</code> to switch
     * between the date and time views.
     * @param {Event} e
     */
    _dateTimeSwitchChange(e: CustomEvent): void;
    /**
     * @override
     */
    _modifyDateValue(amount: number, unit: string, preserveDate: boolean): void;
    getPicker(): Promise<ResponsivePopover>;
    getSelectedDateTime(): Date;
    /**
     * @override
     */
    get _calendarPickersMode(): CalendarPickersMode;
}
export default DateTimePicker;
export type { DateTimePickerChangeEventDetail, DateTimePickerInputEventDetail, };
