import type LocaleData from "@ui5/webcomponents-localization/dist/LocaleData.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import CalendarDate from "@ui5/webcomponents-localization/dist/dates/CalendarDate.js";
import CalendarSelectionMode from "./types/CalendarSelectionMode.js";
import CalendarPart from "./CalendarPart.js";
import type { ICalendarPicker } from "./Calendar.js";
type DayName = {
    name: string;
    classes: string;
    ultraShortName?: string;
};
type Day = {
    timestamp: string;
    day: number;
    focusRef: boolean;
    _tabIndex: string;
    selected: boolean;
    _isSecondaryCalendarType: boolean;
    classes: string;
    ariaLabel: string;
    ariaSelected: string;
    ariaDisabled: string | undefined;
    disabled: boolean;
    secondDay?: number;
    weekNum?: number;
    isHidden?: boolean;
};
type WeekNumber = {
    weekNum: number;
    isHidden: boolean;
};
type Week = Array<Day | WeekNumber>;
type DayPickerChangeEventDetail = {
    dates: Array<number>;
    timestamp?: number;
};
type DayPickerNavigateEventDetail = {
    timestamp: number;
};
/**
 * @class
 *
 * Represents the days inside a single month view of the <code>ui5-calendar</code> component.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.DayPicker
 * @extends sap.ui.webc.main.CalendarPart
 * @tagname ui5-daypicker
 * @public
 */
declare class DayPicker extends CalendarPart implements ICalendarPicker {
    /**
     * An array of UTC timestamps representing the selected date or dates depending on the capabilities of the picker component.
     * @type {array}
     * @name sap.ui.webc.main.DayPicker.prototype.selectedDates
     * @public
     */
    selectedDates: Array<number>;
    /**
     * Defines the type of selection used in the day picker component.
     * Accepted property values are:<br>
     * <ul>
     * <li><code>CalendarSelectionMode.Single</code> - enables a single date selection.(default value)</li>
     * <li><code>CalendarSelectionMode.Range</code> - enables selection of a date range.</li>
     * <li><code>CalendarSelectionMode.Multiple</code> - enables selection of multiple dates.</li>
     * </ul>
     * @type {sap.ui.webc.main.types.CalendarSelectionMode}
     * @name sap.ui.webc.main.DayPicker.prototype.selectionMode
     * @defaultvalue "Single"
     * @public
     */
    selectionMode: `${CalendarSelectionMode}`;
    /**
     * Defines the visibility of the week numbers column.
     * <br><br>
     *
     * <b>Note:<b> For calendars other than Gregorian,
     * the week numbers are not displayed regardless of what is set.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.DayPicker.prototype.hideWeekNumbers
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.8
     */
    hideWeekNumbers: boolean;
    /**
     * @type {object}
     * @private
     */
    _weeks: Array<Week>;
    _dayNames: Array<DayName>;
    /**
     * When set, the component will skip all work in onBeforeRendering and will not automatically set the focus on itself
     * @type {boolean}
     * @private
     */
    _hidden: boolean;
    /**
     * When selectionMode="Range" and the first day in the range is selected, this is the currently hovered (when using mouse) or focused (when using keyboard) day by the user
     * @private
     */
    _secondTimestamp?: number;
    _autoFocus?: boolean;
    static i18nBundle: I18nBundle;
    onBeforeRendering(): void;
    /**
     * Builds the "_weeks" object that represents the month.
     * @param { LocaleData }localeData
     * @private
     */
    _buildWeeks(localeData: LocaleData): void;
    /**
     * Builds the dayNames object (header of the month).
     * @param { LocaleData } localeData
     * @private
     */
    _buildDayNames(localeData: LocaleData): void;
    onAfterRendering(): void;
    _onfocusin(): void;
    _onfocusout(): void;
    /**
     * Tells if the day is selected (dark blue).
     * @param { number } timestamp
     * @returns { boolean }
     * @private
     */
    _isDaySelected(timestamp: number): boolean;
    /**
     * Tells if the day is inside a selection range (light blue).
     * @param { number } timestamp
     * @returns { boolean }
     * @private
     */
    _isDayInsideSelectionRange(timestamp: number): boolean;
    /**
     * Selects/deselects a day.
     * @param { Event} e
     * @param { boolean} isShift true if the user did Click+Shift or Enter+Shift (but not Space+Shift)
     * @private
     */
    _selectDate(e: Event, isShift: boolean): void;
    /**
     * Selects/deselects the whole row (week).
     * @private
     */
    _selectWeek(): void;
    _toggleTimestampInSelection(timestamp: number): void;
    _addTimestampToSelection(timestamp: number): void;
    _removeTimestampFromSelection(timestamp: number): void;
    /**
     * Called when at least one day is selected and the user presses "Shift".
     * @param { number } timestamp
     * @private
     */
    _multipleSelection(timestamp: number): void;
    /**
     * Set the hovered day as the "_secondTimestamp".
     * @param { MouseEvent } e
     * @private
     */
    _onmouseover(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    /**
     * Click is the same as "Enter".
     * <b>Note:</b> "Click+Shift" has the same effect as "Enter+Shift".
     * @param { MouseEvent } e
     * @private
     */
    _onclick(e: MouseEvent): void;
    /**
     * Called upon "Home" or "End" - moves the focus to the first or last item in the row.
     * @param { boolean } homePressed
     * @private
     */
    _onHomeOrEnd(homePressed: boolean): void;
    /**
     * Called by the Calendar component.
     * @protected
     * @returns { boolean }
     */
    _hasPreviousPage(): boolean;
    /**
     * Called by the Calendar component.
     * @protected
     * @returns { boolean }
     */
    _hasNextPage(): boolean;
    /**
     * Called by the Calendar component.
     * @protected
     */
    _showPreviousPage(): void;
    /**
     * Called by the Calendar component.
     * @protected
     */
    _showNextPage(): void;
    /**
     * Modifies the timestamp by a certain amount of days/months/years.
     * @param { number } amount
     * @param { string } unit
     * @param { boolean } preserveDate whether to preserve the day of the month (f.e. 15th of March + 1 month = 15th of April)
     * @private
     */
    _modifyTimestampBy(amount: number, unit: string, preserveDate?: boolean): void;
    /**
     * Sets the timestamp to an absolute value.
     * @param { number } value
     * @private
     */
    _setTimestamp(value: number): void;
    /**
     * During range selection, when the user is navigating with the keyboard,
     * the currently focused day is considered the "second day".
     * @private
     */
    _updateSecondTimestamp(): void;
    get shouldHideWeekNumbers(): boolean;
    get classes(): {
        root: {
            "ui5-dp-root": boolean;
            "ui5-dp-twocalendartypes": boolean;
        };
    };
    _isWeekend(oDate: CalendarDate): boolean;
    _isDayPressed(target: HTMLElement): boolean;
    _getSecondaryDay(tempDate: CalendarDate): CalendarDate;
    _getFirstDay(): CalendarDate;
    _getFirstDayOfWeek(): number;
    get styles(): {
        wrapper: {
            display: string;
            "justify-content": string;
        };
        main: {
            width: string;
        };
    };
    get ariaRoledescription(): string;
}
export default DayPicker;
export type { DayPickerNavigateEventDetail, DayPickerChangeEventDetail, };
