import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { I18nText } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import IconDesign from "./types/IconDesign.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-icon</code> component represents an SVG icon.
 * There are two main scenarios how the <code>ui5-icon</code> component is used:
 * as a purely decorative element, <br>
 * or as an interactive element that can be focused and clicked.
 *
 * <h3>Usage</h3>
 *
 * 1. <b>Get familiar with the icons collections.</b>
 * <br>
 * Before displaying an icon, you need to explore the icons collections to find and import the desired icon.
 * <br>
 * Currently there are 3 icons collection, available as 3 npm packages:
 * <br>
 *
 * <ul>
 * <li>
 * <ui5-link target="_blank" href="https://www.npmjs.com/package/@ui5/webcomponents-icons">@ui5/webcomponents-icons</ui5-link> represents the "SAP-icons" collection and includes the following
 * <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons">icons</ui5-link>.
 * </li>
 * <li>
 * <ui5-link target="_blank" href="https://www.npmjs.com/package/@ui5/webcomponents-icons-tnt">@ui5/webcomponents-icons-tnt</ui5-link> represents the "tnt" collection and includes the following
 * <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT">icons</ui5-link>.
 * </li>
 * <li>
 * <ui5-link target="_blank" href="https://www.npmjs.com/package/@ui5/webcomponents-icons-business-suite">@ui5/webcomponents-icons-icons-business-suite</ui5-link> represents the "business-suite" collection and includes the following
 * <ui5-link target="_blank" href="https://ui5.sap.com/test-resources/sap/m/demokit/iconExplorer/webapp/index.html#/overview/BusinessSuiteInAppSymbols">icons</ui5-link>.
 * </li>
 * </ul>
 *
 * 2. <b>After exploring the icons collections, add one or more of the packages as dependencies to your project.</b>
 * <br>
 * <code>npm i @ui5/webcomponents-icons</code><br>
 * <code>npm i @ui5/webcomponents-icons-tnt</code><br>
 * <code>npm i @ui5/webcomponents-icons-business-suite</code>
 * <br><br>
 *
 * 3. <b>Then, import the desired icon</b>.
 * <br>
 * <code>import "@ui5/{package_name}/dist/{icon_name}.js";</code>
 * <br><br>
 *
 * <b>For Example</b>:
 * <br>
 *
 * For the standard "SAP-icons" icon collection, import an icon from the <code>@ui5/webcomponents-icons</code> package:
 * <br>
 * <code>import "@ui5/webcomponents-icons/dist/employee.js";</code>
 * <br><br>
 *
 * For the "tnt" (SAP Fiori Tools) icon collection, import an icon from the <code>@ui5/webcomponents-icons-tnt</code> package:
 * <br>
 * <code>import "@ui5/webcomponents-icons-tnt/dist/antenna.js";</code>
 * <br><br>
 *
 * For the "business-suite" (SAP Business Suite) icon collection, import an icon from the <code>@ui5/webcomponents-icons-business-suite</code> package:
 * <br>
 * <code>import "@ui5/webcomponents-icons-business-suite/dist/ab-testing.js";</code>
 * <br><br>
 *
 * 4. <b>Display the icon using the <code>ui5-icon</code> web component.</b><br>
 * Set the icon collection ("SAP-icons", "tnt" or "business-suite" - "SAP-icons" is the default icon collection and can be skipped)<br>
 * and the icon name to the <code>name</code> property.
 * <br><br>
 *
 * <code>&lt;ui5-icon name="employee">&lt;/ui5-icon></code><br>
 * <code>&lt;ui5-icon name="tnt/antenna">&lt;/ui5-icon></code><br>
 * <code>&lt;ui5-icon name="business-suite/ab-testing">&lt;/ui5-icon></code>
 *
 * <br><br>
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-icon</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>root - Used to style the outermost wrapper of the <code>ui5-icon</code></li>
 * </ul>
 *
 * <br><br>
 * <h3>Keyboard Handling</h3>
 *
 * <ul>
 * <li>[SPACE, ENTER, RETURN] - Fires the <code>click</code> event if the <code>interactive</code> property is set to true.</li>
 * <li>[SHIFT] - If [SPACE] or [ENTER],[RETURN] is pressed, pressing [SHIFT] releases the ui5-icon without triggering the click event.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Icon.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Icon
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-icon
 * @implements sap.ui.webc.main.IIcon
 * @public
 */
declare class Icon extends UI5Element {
    /**
     * Defines the component semantic design.
     *
     * @type {sap.ui.webc.main.types.IconDesign}
     * @name sap.ui.webc.main.Icon.prototype.design
     * @defaultvalue "Default"
     * @public
     * @since 1.9.2
     */
    design: `${IconDesign}`;
    /**
     * Defines if the icon is interactive (focusable and pressable)
     * @name sap.ui.webc.main.Icon.prototype.interactive
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.8
     */
    interactive: boolean;
    /**
     * Defines the unique identifier (icon name) of the component.
     * <br>
     *
     * To browse all available icons, see the
     * <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">SAP Icons</ui5-link>,
     * <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT">SAP Fiori Tools</ui5-link> and
     * <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">SAP Business Suite</ui5-link> collections.
     * <br>
     *
     * Example:
     * <br>
     * <code>name='add'</code>, <code>name='delete'</code>, <code>name='employee'</code>.
     * <br><br>
     *
     * <b>Note:</b> To use the SAP Fiori Tools icons,
     * you need to set the <code>tnt</code> prefix in front of the icon's name.
     * <br>
     *
     * Example:
     * <br>
     * <code>name='tnt/antenna'</code>, <code>name='tnt/actor'</code>, <code>name='tnt/api'</code>.
     * <br><br>
     *
     * <b>Note:</b> To use the SAP Business Suite icons,
     * you need to set the <code>business-suite</code> prefix in front of the icon's name.
     * <br>
     *
     * Example:
     * <br>
     * <code>name='business-suite/3d'</code>, <code>name='business-suite/1x2-grid-layout'</code>, <code>name='business-suite/4x4-grid-layout'</code>.
     * @name sap.ui.webc.main.Icon.prototype.name
     * @type {string}
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines the text alternative of the component.
     * If not provided a default text alternative will be set, if present.
     * <br><br>
     * <b>Note:</b> Every icon should have a text alternative in order to
     * calculate its accessible name.
     *
     * @name sap.ui.webc.main.Icon.prototype.accessibleName
     * @type {string}
     * @defaultvalue ""
     * @public
     */
    accessibleName: string;
    /**
     * Defines whether the component should have a tooltip.
     * <br><br>
     * <b>Note:</b> The tooltip text should be provided via the <code>accessible-name</code> property.
     *
     * @name sap.ui.webc.main.Icon.prototype.showTooltip
     * @type {boolean}
     * @defaultvalue false
     * @public
     */
    showTooltip: boolean;
    /**
     * Defines the accessibility role of the component.
     * @name sap.ui.webc.main.Icon.prototype.accessibleRole
     * @type {string}
     * @defaultvalue ""
     * @public
     * @since 1.1.0
     */
    accessibleRole: string;
    /**
     * Defines the ARIA hidden state of the component.
     * Note: If the role is presentation the default value of aria-hidden will be true.
     * @private
     * @since 1.0.0-rc.15
     */
    ariaHidden: string;
    /**
     * @private
     */
    pathData: Array<string>;
    /**
     * @private
     */
    accData?: I18nText;
    /**
     * @private
     */
    focused: boolean;
    /**
    * @private
    */
    invalid: boolean;
    /**
     * @private
     */
    effectiveAccessibleName?: string;
    ltr?: boolean;
    packageName?: string;
    viewBox?: string;
    customSvg?: object;
    _onfocusout?: ((event: FocusEvent) => void);
    _onfocusin?: ((event: FocusEvent) => void);
    _onFocusInHandler(): void;
    _onFocusOutHandler(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    /**
    * Enforce "ltr" direction, based on the icons collection metadata.
    */
    get _dir(): "ltr" | undefined;
    get effectiveAriaHidden(): string | true | undefined;
    get _tabIndex(): "0" | undefined;
    get isDecorative(): boolean;
    get effectiveAccessibleRole(): string;
    onBeforeRendering(): Promise<void>;
    get hasIconTooltip(): string | false | undefined;
}
export default Icon;
