/**
 * Interface for components that represent an avatar and may be slotted in numerous higher-order components such as <code>ui5-avatar-group</code>
 *
 * @name sap.ui.webc.main.IAvatar
 * @interface
 * @public
 */
declare const IAvatar = "sap.ui.webc.main.IAvatar";
/**
 * Interface for components that may be slotted inside <code>ui5-breadcrumbs</code> as options
 *
 * @name sap.ui.webc.main.IBreadcrumbsItem
 * @interface
 * @public
 */
declare const IBreadcrumbsItem = "sap.ui.webc.main.IBreadcrumbsItem";
/**
 * Interface for components that may be used as a button inside numerous higher-order components
 *
 * @name sap.ui.webc.main.IButton
 * @interface
 * @public
 */
declare const IButton = "sap.ui.webc.main.IButton";
/**
 * Interface for components that may be slotted inside <code>ui5-card</code> as header
 *
 * @name sap.ui.webc.main.ICardHeader
 * @interface
 * @public
 */
declare const ICardHeader = "sap.ui.webc.main.ICardHeader";
/**
 * Interface for components that may be used as dates inside <code>ui5-calendar</code>
 *
 * @name sap.ui.webc.main.ICalendarDate
 * @interface
 * @public
 */
declare const ICalendarDate = "sap.ui.webc.main.ICalendarDate";
/**
 * Interface for components that may be slotted inside a <code>ui5-combobox</code>
 *
 * @name sap.ui.webc.main.IComboBoxItem
 * @interface
 * @public
 */
declare const IComboBoxItem = "sap.ui.webc.main.IComboBoxItem";
/**
 * Interface for components that may be used inside a <code>ui5-color-palette</code> or <code>ui5-color-palette-popover</code>
 *
 * @name sap.ui.webc.main.IColorPaletteItem
 * @interface
 * @public
 */
declare const IColorPaletteItem = "sap.ui.webc.main.IColorPaletteItem";
/**
 * Interface for components that represent an icon, usable in numerous higher-order components
 *
 * @name sap.ui.webc.main.IIcon
 * @interface
 * @public
 */
declare const IIcon = "sap.ui.webc.main.IIcon";
/**
 * Interface for components that represent an input, usable in numerous higher-order components
 *
 * @name sap.ui.webc.main.IInput
 * @interface
 * @public
 */
declare const IInput = "sap.ui.webc.main.IInput";
/**
 * Interface for components that represent a suggestion item, usable in <code>ui5-input</code>
 *
 * @name sap.ui.webc.main.IInputSuggestionItem
 * @interface
 * @public
 */
declare const IInputSuggestionItem = "sap.ui.webc.main.IInputSuggestionItem";
/**
 * Interface for components that may be slotted inside a <code>ui5-list</code> as items
 *
 * @name sap.ui.webc.main.IListItem
 * @interface
 * @public
 */
declare const IListItem = "sap.ui.webc.main.IListItem";
/**
 * Interface for components that may be slotted inside <code>ui5-menu</code> as items
 *
 * @name sap.ui.webc.main.IMenuItem
 * @interface
 * @public
 */
declare const IMenuItem = "sap.ui.webc.main.IMenuItem";
/**
 * Interface for components that may be slotted inside a <code>ui5-multi-combobox</code> as items
 *
 * @name sap.ui.webc.main.IMultiComboBoxItem
 * @interface
 * @public
 */
declare const IMultiComboBoxItem = "sap.ui.webc.main.IMultiComboBoxItem";
/**
 * Interface for components that may be slotted inside <code>ui5-segmented-button</code> as items
 *
 * @name sap.ui.webc.main.ISegmentedButtonItem
 * @interface
 * @public
 */
declare const ISegmentedButtonItem = "sap.ui.webc.main.ISegmentedButtonItem";
/**
 * Interface for components that may be slotted inside <code>ui5-select</code> as options
 *
 * @name sap.ui.webc.main.ISelectOption
 * @interface
 * @public
 */
declare const ISelectOption = "sap.ui.webc.main.ISelectOption";
/**
 * Interface for components that may be slotted inside <code>ui5-select-menu</code> as options
 *
 * @name sap.ui.webc.main.ISelectMenuOption
 * @interface
 * @public
 */
declare const ISelectMenuOption = "sap.ui.webc.main.ISelectMenuOption";
/**
 * Interface for components that may be slotted inside <code>ui5-tabcontainer</code>
 *
 * @name sap.ui.webc.main.ITab
 * @interface
 * @public
 */
declare const ITab = "sap.ui.webc.main.ITab";
/**
 * Interface for components that may be slotted inside a <code>ui5-table</code> as rows
 *
 * @name sap.ui.webc.main.ITableRow
 * @interface
 * @public
 */
declare const ITableRow = "sap.ui.webc.main.ITableRow";
/**
 * Interface for components that may be slotted inside a <code>ui5-table</code> as columns
 *
 * @name sap.ui.webc.main.ITableColumn
 * @interface
 * @public
 */
declare const ITableColumn = "sap.ui.webc.main.ITableColumn";
/**
 * Interface for components that may be slotted inside a <code>ui5-table-row</code> as cells
 *
 * @name sap.ui.webc.main.ITableCell
 * @interface
 * @public
 */
declare const ITableCell = "sap.ui.webc.main.ITableCell";
/**
 * Interface for components that represent a token and are usable in components such as <code>ui5-multi-input</code>
 *
 * @name sap.ui.webc.main.IToken
 * @interface
 * @public
 */
declare const IToken = "sap.ui.webc.main.IToken";
/**
 * Interface for tree items for the purpose of <code>ui5-tree</code>
 *
 * @name sap.ui.webc.main.ITreeItem
 * @interface
 * @public
 */
declare const ITreeItem = "sap.ui.webc.main.ITreeItem";
/**
 * Interface for toolbar items for the purpose of <code>ui5-toolbar</code>
 *
 * @name sap.ui.webc.main.IToolbarItem
 * @interface
 * @public
 */
declare const IToolbarItem = "sap.ui.webc.main.IToolbarItem";
/**
 * Interface for toolbar select items for the purpose of <code>ui5-toolbar-select</code>
 *
 * @name sap.ui.webc.main.IToolbarSelectOption
 * @interface
 * @public
 */
declare const IToolbarSelectOption = "sap.ui.webc.main.IToolbarSelectOption";
export { IAvatar, IBreadcrumbsItem, IButton, ICardHeader, ICalendarDate, IColorPaletteItem, IComboBoxItem, IIcon, IInput, IInputSuggestionItem, IListItem, IMenuItem, IMultiComboBoxItem, ISegmentedButtonItem, ISelectOption, ISelectMenuOption, ITab, ITableCell, ITableColumn, ITableRow, IToken, ITreeItem, IToolbarItem, IToolbarSelectOption, };
