import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
/**
 * @class
 * A class to serve as a foundation
 * for the <code>ListItem</code> and <code>GroupHeaderListItem</code> classes.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ListItemBase
 * @extends sap.ui.webc.base.UI5Element
 * @public
 */
declare class ListItemBase extends UI5Element implements ITabbable {
    /**
     * Defines the selected state of the <code>ListItem</code>.
     * @type {boolean}
     * @name sap.ui.webc.main.ListItemBase.prototype.selected
     * @defaultvalue false
     * @public
     */
    selected: boolean;
    /**
    * Defines if the list item should display its bottom border.
    * @private
    */
    hasBorder: boolean;
    _tabIndex: string;
    /**
    * Defines whether <code>ui5-li</code> is in disabled state.
    * <br><br>
    * <b>Note:</b> A disabled <code>ui5-li</code> is noninteractive.
    * @type {boolean}
    * @name sap.ui.webc.main.ListItemBase.prototype.disabled
    * @defaultvalue false
    * @protected
    * @since 1.0.0-rc.12
    */
    disabled: boolean;
    /**
     * Indicates if the element is on focus
     * @private
     */
    focused: boolean;
    _onfocusin(e: FocusEvent): void;
    _onfocusout(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _handleTabNext(e: KeyboardEvent): void;
    _handleTabPrevious(e: KeyboardEvent): void;
    shouldForwardTabAfter(): boolean;
    shouldForwardTabBefore(target: HTMLElement): boolean;
    get classes(): ClassMap;
    get _ariaDisabled(): true | undefined;
    get hasConfigurableMode(): boolean;
    get _effectiveTabIndex(): string | 0 | -1;
}
export default ListItemBase;
