import ComboBoxItem from "./ComboBoxItem.js";
import type { IMultiComboBoxItem } from "./MultiComboBox.js";
/**
 * @class
 * The <code>ui5-mcb-item</code> represents the item for a <code>ui5-multi-combobox</code>.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.MultiComboBoxItem
 * @extends sap.ui.webc.main.ComboBoxItem
 * @abstract
 * @tagname ui5-mcb-item
 * @implements sap.ui.webc.main.IMultiComboBoxItem
 * @public
 */
declare class MultiComboBoxItem extends ComboBoxItem implements IMultiComboBoxItem {
    /**
     * Defines the selected state of the component.
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBoxItem.prototype.selected
     * @defaultvalue false
     * @public
     */
    selected: boolean;
    get stableDomRef(): string;
}
export default MultiComboBoxItem;
