import Input from "./Input.js";
import Token from "./Token.js";
import Tokenizer from "./Tokenizer.js";
import type { TokenizerTokenDeleteEventDetail } from "./Tokenizer.js";
import "@ui5/webcomponents-icons/dist/value-help.js";
import type { InputSuggestionItemSelectEventDetail as MultiInputSuggestionItemSelectEventDetail, InputSuggestionItemPreviewEventDetail as MultiInputSuggestionItemPreviewEventDetail } from "./Input.js";
type MultiInputTokenDeleteEventDetail = {
    token: Token;
};
/**
 * @class
 * <h3>Overview</h3>
 * A <code>ui5-multi-input</code> field allows the user to enter multiple values, which are displayed as <code>ui5-token</code>.
 *
 * User can choose interaction for creating tokens.
 * Fiori Guidelines say that user should create tokens when:
 * <ul>
 * <li>Type a value in the input and press enter or focus out the input field (<code>change</code> event is fired)</li>
 * <li>Select a value from the suggestion list (<code>suggestion-item-select</code> event is fired)</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/MultiInput";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.MultiInput
 * @extends sap.ui.webc.main.Input
 * @tagname ui5-multi-input
 * @appenddocs sap.ui.webc.main.Token
 * @since 1.0.0-rc.9
 * @public
 */
declare class MultiInput extends Input {
    /**
     * Determines whether a value help icon will be visualized in the end of the input.
     * Pressing the icon will fire <code>value-help-trigger</code> event.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiInput.prototype.showValueHelpIcon
     * @defaultvalue false
     * @public
     */
    showValueHelpIcon: boolean;
    /**
     * Indicates whether the tokenizer is expanded or collapsed(shows the n more label)
     * @defaultvalue false
     * @private
     */
    expandedTokenizer: boolean;
    /**
     * Indicates whether the tokenizer has tokens
     * @defaultvalue false
     * @private
     */
    tokenizerAvailable: boolean;
    /**
     * Defines the component tokens.
     *
     * @type {sap.ui.webc.main.IToken[]}
     * @name sap.ui.webc.main.MultiInput.prototype.tokens
     * @slot tokens
     * @public
     */
    tokens: Array<Token>;
    _skipOpenSuggestions: boolean;
    _valueHelpIconPressed: boolean;
    constructor();
    valueHelpPress(): void;
    showMorePress(): void;
    tokenDelete(e: CustomEvent<TokenizerTokenDeleteEventDetail>): void;
    valueHelpMouseDown(e: MouseEvent): void;
    _tokenizerFocusOut(e: FocusEvent): void;
    valueHelpMouseUp(): void;
    innerFocusIn(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onTokenizerKeydown(e: KeyboardEvent): void;
    _handleLeft(e: KeyboardEvent): void;
    _focusFirstToken(e: KeyboardEvent): void;
    _onfocusout(e: FocusEvent): void;
    /**
     * @override
     */
    _onfocusin(e: FocusEvent): Promise<void>;
    lastItemDeleted(): void;
    onBeforeRendering(): void;
    get iconsCount(): number;
    get tokenizer(): Tokenizer;
    get _tokensCountText(): string | undefined;
    get _tokensCountTextId(): string;
    /**
     * Returns the placeholder value when there are no tokens.
     * @protected
     */
    get _placeholder(): string;
    get accInfo(): {
        input: {
            ariaRoledescription: string;
            ariaDescribedBy: string;
            ariaInvalid: string | undefined;
            ariaHasPopup: string | undefined;
            ariaAutoComplete: string | undefined;
            role: string | undefined;
            ariaControls: string | undefined;
            ariaExpanded: string | undefined;
            ariaDescription: string | undefined;
            ariaLabel: string | undefined;
        };
    };
    get ariaRoleDescription(): string;
    get morePopoverOpener(): HTMLElement;
}
export default MultiInput;
export type { MultiInputTokenDeleteEventDetail, MultiInputSuggestionItemSelectEventDetail, MultiInputSuggestionItemPreviewEventDetail, };
