import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * Shows the progress of a process in a graphical way. To indicate the progress,
 * the inside of the component is filled with a color.
 *
 * <h3>Responsive Behavior</h3>
 * You can change the size of the Progress Indicator by changing its <code>width</code> or <code>height</code> CSS properties.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/ProgressIndicator.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ProgressIndicator
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-progress-indicator
 * @public
 * @since 1.0.0-rc.8
 */
declare class ProgressIndicator extends UI5Element {
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.ProgressIndicator.prototype.accessibleName
     * @public
     * @since 1.16.0
    */
    accessibleName: string;
    /**
     * Defines whether component is in disabled state.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.ProgressIndicator.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines whether the component value is shown.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.ProgressIndicator.prototype.hideValue
     * @defaultvalue false
     * @public
     */
    hideValue: boolean;
    /**
     * Specifies the numerical value in percent for the length of the component.
     *
     * <b>Note:</b>
     * If a value greater than 100 is provided, the percentValue is set to 100. In other cases of invalid value, percentValue is set to its default of 0.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.ProgressIndicator.prototype.value
     * @defaultvalue 0
     * @public
     */
    value: number;
    /**
     * Specifies the text value to be displayed in the bar.
     *
     * <b>Note:</b>
     * <ul>
     * <li>If there is no value provided or the value is empty, the default percentage value is shown.</li>
     * <li>If <code>hideValue</code> property is <code>true</code> both the <code>displayValue</code> and <code>value</code> property values are not shown.</li>
     * </ul>
     *
     * @type {string}
     * @name sap.ui.webc.main.ProgressIndicator.prototype.displayValue
     * @public
     */
    displayValue: string;
    /**
     * Defines the value state of the component.
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.ProgressIndicator.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    static i18nBundle: I18nBundle;
    _previousValue: number;
    _transitionDuration: number;
    constructor();
    onBeforeRendering(): void;
    valueStateTextMappings(): Record<string, string>;
    valueStateIconMappings(): Record<string, string>;
    get styles(): {
        bar: {
            width: string;
            "transition-duration": string;
        };
    };
    get classes(): {
        root: {
            "ui5-progress-indicator-max-value": boolean;
            "ui5-progress-indicator-min-value": boolean;
        };
    };
    get validatedValue(): number;
    get showValueInRemainingBar(): boolean;
    get shouldAnimate(): boolean;
    get valueStateText(): string;
    get showIcon(): boolean;
    get valueStateIcon(): string;
    get _ariaDisabled(): true | undefined;
    static onDefine(): Promise<void>;
}
export default ProgressIndicator;
