import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { PopupBeforeCloseEventDetail } from "./Popup.js";
import Popover from "./Popover.js";
import Dialog from "./Dialog.js";
import "@ui5/webcomponents-icons/dist/decline.js";
type ResponsivePopoverBeforeCloseEventDetail = PopupBeforeCloseEventDetail;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-responsive-popover</code> acts as a Popover on desktop and tablet, while on phone it acts as a Dialog.
 * The component improves tremendously the user experience on mobile.
 *
 * <h3>Usage</h3>
 * Use it when you want to make sure that all the content is visible on any device.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-responsive-popover</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>header - Used to style the header of the component</li>
 * <li>content - Used to style the content of the component</li>
 * <li>footer - Used to style the footer of the component</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ResponsivePopover
 * @extends sap.ui.webc.main.Popover
 * @tagname ui5-responsive-popover
 * @since 1.0.0-rc.6
 * @public
 */
declare class ResponsivePopover extends Popover {
    /**
     * Defines if only the content would be displayed (without header and footer) in the popover on Desktop.
     * By default both the header and footer would be displayed.
     * @private
     */
    contentOnlyOnDesktop: boolean;
    /**
     * Used internaly for controls which must not have header.
     * @private
     */
    _hideHeader: boolean;
    /**
     * Defines whether a close button will be rendered in the header of the component
     * <b>Note:</b> If you are using the <code>header</code> slot, this property will have no effect
     *
     * @private
     * @type {boolean}
     * @defaultvalue false
     * @since 1.0.0-rc.16
     */
    _hideCloseButton: boolean;
    static i18nBundle: I18nBundle;
    constructor();
    /**
     * Shows popover on desktop and dialog on mobile.
     * @param {HTMLElement} opener the element that the popover is shown at
     * @param {boolean} [preventInitialFocus=false] Prevents applying the focus inside the popup
     * @public
     * @async
     * @method
     * @name sap.ui.webc.main.ResponsivePopover#showAt
     * @returns {Promise} Resolves when the responsive popover is open
     */
    showAt(opener: HTMLElement, preventInitialFocus?: boolean): Promise<void>;
    /**
     * Closes the popover/dialog.
     * @public
     * @method
     * @name sap.ui.webc.main.ResponsivePopover#close
     * @returns {void}
     */
    close(escPressed?: boolean, preventRegistryUpdate?: boolean, preventFocusRestore?: boolean): void;
    toggle(opener: HTMLElement): void;
    /**
     * Tells if the responsive popover is open.
     * @public
     * @method
     * @name sap.ui.webc.main.ResponsivePopover#isOpen
     * @returns {boolean}
     */
    isOpen(): boolean;
    get classes(): import("@ui5/webcomponents-base/dist/types.js").ClassMap;
    get _dialog(): Dialog;
    get contentDOM(): HTMLElement;
    get _isPhone(): boolean;
    get _displayHeader(): boolean;
    get _displayFooter(): boolean;
    get _closeDialogAriaLabel(): string;
    _beforeDialogOpen(e: CustomEvent<PopupBeforeCloseEventDetail>): void;
    _afterDialogClose(e: CustomEvent): void;
    _propagateDialogEvent(e: CustomEvent): void;
    get isModal(): boolean;
    static onDefine(): Promise<void>;
}
export default ResponsivePopover;
export type { ResponsivePopoverBeforeCloseEventDetail, };
