import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import SegmentedButtonItem from "./SegmentedButtonItem.js";
import SegmentedButtonMode from "./types/SegmentedButtonMode.js";
type SegmentedButtonSelectionChangeEventDetail = {
    selectedItem: SegmentedButtonItem;
    selectedItems: Array<SegmentedButtonItem>;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-segmented-button</code> shows a group of items. When the user clicks or taps
 * one of the items, it stays in a pressed state. It automatically resizes the items
 * to fit proportionally within the component. When no width is set, the component uses the available width.
 * <br><br>
 * <b>Note:</b> There can be just one selected <code>item</code> at a time.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/SegmentedButton";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SegmentedButton
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-segmented-button
 * @since 1.0.0-rc.6
 * @appenddocs sap.ui.webc.main.SegmentedButtonItem
 * @public
 */
declare class SegmentedButton extends UI5Element {
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @defaultvalue undefined
     * @public
     * @name sap.ui.webc.main.SegmentedButton.prototype.accessibleName
     * @since 1.0.3
     */
    accessibleName?: string;
    /**
     * Defines the component selection mode.
     *
     * <br><br>
     * <b>The available values are:</b>
     *
     * <ul>
     * <li><code>SingleSelect</code></li>
     * <li><code>MultiSelect</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.SegmentedButtonMode}
     * @defaultvalue "SingleSelect"
     * @public
     * @name sap.ui.webc.main.SegmentedButton.prototype.mode
     * @since 1.14.0
     */
    mode: `${SegmentedButtonMode}`;
    /**
     * Defines the items of <code>ui5-segmented-button</code>.
     * <br><br>
     * <b>Note:</b> Multiple items are allowed.
     * <br><br>
     * <b>Note:</b> Use the <code>ui5-segmented-button-item</code> for the intended design.
     * @type {sap.ui.webc.main.ISegmentedButtonItem[]}
     * @name sap.ui.webc.main.SegmentedButton.prototype.default
     * @slot items
     * @public
     */
    items: Array<SegmentedButtonItem>;
    static i18nBundle: I18nBundle;
    _itemNavigation: ItemNavigation;
    hasPreviouslyFocusedItem: boolean;
    _selectedItem?: SegmentedButtonItem;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    normalizeSelection(): void;
    _selectItem(e: MouseEvent | KeyboardEvent): this | undefined;
    _applySingleSelection(item: SegmentedButtonItem): void;
    _onclick(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onmousedown(e: MouseEvent): void;
    _onfocusin(e: FocusEvent): void;
    /**
     * Currently selected item.
     *
     * @readonly
     * @type {sap.ui.webc.main.ISegmentedButtonItem}
     * @name sap.ui.webc.main.SegmentedButton.prototype.selectedItem
     * @deprecated since 1.14.0. This method will be removed in the next major release.
     * Please use the <code>selectedItems</code> property instead.
     * @public
     */
    get selectedItem(): SegmentedButtonItem | undefined;
    /**
     * Returns an array of the currently selected items.
     * @readonly
     * @name sap.ui.webc.main.SegmentedButton.prototype.selectedItems
     * @type {sap.ui.webc.main.ISegmentedButtonItem[]}
     * @since 1.14.0
     * @public
     */
    get selectedItems(): Array<SegmentedButtonItem>;
    get ariaDescribedBy(): string;
    get ariaDescription(): string;
}
export default SegmentedButton;
export type { SegmentedButtonSelectionChangeEventDetail, };
