import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import ResponsivePopover from "./ResponsivePopover.js";
import type Select from "./Select.js";
import type SelectMenuOption from "./SelectMenuOption.js";
type SelectMenuOptionClick = {
    option: SelectMenuOption;
    optionIndex: number;
};
type SelectMenuChange = {
    text: string;
    selectedIndex: number;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-select-menu</code> is meant to be used together with the <code>ui5-select</code> component as alternative
 * to define the select's dropdown. It acts as a popover on desktop and tablet, and as a Dialog on phone.
 * <br></br>
 * The component gives the possibility to the user to customize the <code>ui5-select</code>'s dropdown
 * by slotting custom options and adding custom styles.
 *
 * <h3>Usage</h3>
 *
 * To use <code>ui5-select</code> with a <code>ui5-select-menu</code>,
 * you need to set the <code>ui5-select</code> <code>menu</code> property to reference <code>ui5-select-menu</code> either by ID or DOM reference.
 * <br></br>
 *
 * For the <code>ui5-select-menu</code>
 * <h3>ES6 Module Import</h3>
 *
 * <code>import @ui5/webcomponents/dist/SelectMenu.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SelectMenu
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-select-menu
 * @public
 * @since 1.17.0
 */
declare class SelectMenu extends UI5Element {
    constructor();
    /**
     * Defines the options of the component.
     *
     * @type {sap.ui.webc.main.ISelectMenuOption[]}
     * @name sap.ui.webc.main.SelectMenu.prototype.default
     * @slot
     * @public
     */
    options: Array<SelectMenuOption>;
    /**
     * Defines the width of the component.
     *
     * @type { number }
     * @name sap.ui.webc.main.SelectMenu.prototype.selectWidth
     * @private
     */
    selectWidth?: number;
    hasValueState: boolean;
    hasValueStateSlot: boolean;
    valueState: `${ValueState}`;
    valueStateText: string;
    value: string;
    valueStateMessageText: Array<Node>;
    _headerTitleText?: string;
    select?: Select;
    /**
     * Shows the dropdown at the given element.
     */
    showAt(opener: Select, openerWidth: number): void;
    /**
     * Closes the dropdown.
     */
    close(escPressed?: boolean, preventRegistryUpdate?: boolean, preventFocusRestore?: boolean): void;
    onBeforeRendering(): void;
    _syncSelection(): void;
    _onOptionClick(e: CustomEvent): void;
    _onBeforeOpen(): void;
    _onAfterOpen(): void;
    _onAfterClose(): void;
    _onCloseBtnClick(): void;
    get open(): boolean;
    get respPopover(): ResponsivePopover;
    get classes(): {
        popoverValueState: {
            "ui5-valuestatemessage-root": boolean;
            "ui5-valuestatemessage--success": boolean;
            "ui5-valuestatemessage--error": boolean;
            "ui5-valuestatemessage--warning": boolean;
            "ui5-valuestatemessage--information": boolean;
        };
        popover: {
            "ui5-select-popover-valuestate": boolean;
        };
    };
    get styles(): {
        responsivePopoverHeader: {
            display: string;
            width: string;
        };
        responsivePopover: {
            "min-width": string;
        };
    };
    get _valueStateMessageInputIcon(): string;
    get _isPhone(): boolean;
}
export default SelectMenu;
export type { SelectMenuOptionClick, SelectMenuChange, };
