import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
import ButtonDesign from "./types/ButtonDesign.js";
import Button from "./Button.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-split-button</code> enables users to trigger actions. It is constructed of two separate actions -
 * default action and arrow action that can be activated by clicking or tapping, or by
 * pressing certain keyboard keys - <code>Space</code> or <code>Enter</code> for default action,
 * and <code>Arrow Down</code> or <code>Arrow Up</code> for arrow action.
 *
 * <h3>Usage</h3>
 *
 * <code>ui5-split-button</code> consists two separate buttons:
 * <ul>
 * <li>for the first one (default action) you can define some <code>text</code> or an <code>icon</code>, or both.
 * Also, it is possible to define different icon for active state of this button - <code>activeIcon</code>.</li>
 * <li>the second one (arrow action) contains only <code>slim-arrow-down</code> icon.</li>
 * </ul>
 * You can choose a <code>design</code> from a set of predefined types (the same as for ui5-button) that offer
 * different styling to correspond to the triggered action. Both text and arrow actions have the same design.
 * <br><br>
 * You can set the <code>ui5-split-button</code> as enabled or disabled. Both parts of an enabled
 * <code>ui5-split-button</code> can be pressed by clicking or tapping it, or by certain keys, which changes
 * the style to provide visual feedback to the user that it is pressed or hovered over with
 * the mouse cursor. A disabled <code>ui5-split-button</code> appears inactive and any of the two buttons
 * cannot be pressed.
 *
 * <h3>Keyboard Handling</h3>
 * <ul>
 * <li><code>Space</code> or <code>Enter</code> - triggers the default action</li>
 * <li><code>Shift</code> or <code>Escape</code> - if <code>Space</code> is pressed, releases the default action button without triggering the click event.</li>
 * <li><code>Arrow Down</code>, <code>Arrow Up</code>, <code>Alt</code>+<code>Arrow Down</code>, <code>Alt</code>+<code>Arrow Up</code>, or <code>F4</code> - triggers the arrow action</li>
 * There are separate events that are fired on activating of <code>ui5-split-button</code> parts:
 * <ul>
 * <li><code>click</code> for the first button (default action)</li>
 * <li><code>arrow-click</code> for the second button (arrow action)</li>
 * </ul>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/SplitButton.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SplitButton
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-split-button
 * @public
 * @since 1.1.0
 */
declare class SplitButton extends UI5Element {
    /**
     * Defines the icon to be displayed as graphical element within the component.
     * The SAP-icons font provides numerous options.
     * <br><br>
     * Example:
     *
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     *
     * @type {string}
     * @name sap.ui.webc.main.SplitButton.prototype.icon
     * @defaultvalue ""
     * @public
     */
    icon: string;
    /**
     * Defines the icon to be displayed in active state as graphical element within the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.SplitButton.prototype.activeIcon
     * @defaultvalue ""
     * @public
     */
    activeIcon: string;
    /**
     * Defines the component design.
     *
     * @type {sap.ui.webc.main.types.ButtonDesign}
     * @name sap.ui.webc.main.SplitButton.prototype.design
     * @defaultvalue "Default"
     * @public
     */
    design: `${ButtonDesign}`;
    /**
     * Defines whether the component is disabled.
     * A disabled component can't be pressed or
     * focused, and it is not in the tab chain.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.SplitButton.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.SplitButton.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     */
    accessibleName?: string;
    /**
     * Indicates if the elements is on focus
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    focused: boolean;
    /**
     * Accessibility-related properties for inner elements of the Split Button
     *
     * @type {object}
     * @private
     */
    _splitButtonAccInfo: Record<string, boolean>;
    /**
     * Defines the tabIndex of the component.
     * @type {string}
     * @defaultvalue ""
     * @private
     */
    _tabIndex: string;
    /**
     * Indicates if there is Space key pressed
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _spacePressed: boolean;
    /**
     * Indicates if there is SHIFT or ESCAPE key pressed
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _shiftOrEscapePressed: boolean;
    /**
     * Defines the active state of the text button
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _textButtonActive: boolean;
    /**
     * Defines the icon of the text button
     * @type {string}
     * @defaultvalue ""
     * @private
     */
    _textButtonIcon: string;
    /**
     * Defines the active state of the arrow button
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _arrowButtonActive: boolean;
    /**
     * Defines the text of the component.
     * <br><br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.SplitButton.prototype.default
     * @slot
     * @public
     */
    text: Array<Node>;
    _textButtonPress: {
        handleEvent: () => void;
        passive: boolean;
    };
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    _onFocusOut(e: FocusEvent): void;
    _onFocusIn(e: FocusEvent): void;
    _onKeyDown(e: KeyboardEvent): void;
    _onKeyUp(e: KeyboardEvent): void;
    _fireClick(e?: Event): void;
    _fireArrowClick(e?: Event): void;
    _textButtonRelease(): void;
    _setTabIndexValue(): void;
    get textButtonAccText(): string | null;
    get isTextButton(): boolean;
    get textButton(): Button | null | undefined;
    get arrowButton(): Button | null | undefined;
    get accessibilityInfo(): {
        ariaExpanded: boolean;
        ariaHaspopup: boolean;
        description: string;
        keyboardHint: string;
    };
    get ariaLabelText(): string;
}
export default SplitButton;
