import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import { Timeout } from "@ui5/webcomponents-base/dist/types.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
import "@ui5/webcomponents-icons/dist/less.js";
import "@ui5/webcomponents-icons/dist/add.js";
import Input from "./Input.js";
import InputType from "./types/InputType.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-step-input</code> consists of an input field and buttons with icons to increase/decrease the value
 * with the predefined step.
 * <br><br>
 * The user can change the value of the component by pressing the increase/decrease buttons,
 * by typing a number directly, by using the keyboard up/down and page up/down,
 * or by using the mouse scroll wheel. Decimal values are supported.
 *
 * <h3>Usage</h3>
 *
 * The default step is 1 but the app developer can set a different one.
 *
 * App developers can set a maximum and minimum value for the <code>StepInput</code>.
 * The increase/decrease button and the up/down keyboard navigation become disabled when
 * the value reaches the max/min or a new value is entered from the input which is greater/less than the max/min.
 * <br><br>
 * <h4>When to use:</h4>
 * <ul>
 * <li>To adjust amounts, quantities, or other values quickly.</li>
 * <li>To adjust values for a specific step.</li>
 * </ul>
 *
 * <h4>When not to use:</h4>
 * <ul>
 * <li>To enter a static number (for example, postal code, phone number, or ID). In this case,
 * use the regular <code>ui5-input</code> instead.</li>
 * <li>To display a value that rarely needs to be adjusted and does not pertain to a particular step.
 * In this case, use the regular <code>ui5-input</code> instead.</li>
 * <li>To enter dates and times. In this case, use date/time related components instead.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/StepInput.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.StepInput
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-step-input
 * @since 1.0.0-rc.13
 * @public
 */
declare class StepInput extends UI5Element implements IFormElement {
    /**
     * Defines a value of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.value
     * @type {sap.ui.webc.base.types.Float}
     * @defaultvalue 0
     * @public
     */
    value: number;
    /**
     * Defines a minimum value of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.min
     * @type {sap.ui.webc.base.types.Float}
     * @public
     */
    min?: number;
    /**
     * Defines a maximum value of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.max
     * @type {sap.ui.webc.base.types.Float}
     * @public
     */
    max?: number;
    /**
     * Defines a step of increasing/decreasing the value of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.step
     * @type {sap.ui.webc.base.types.Float}
     * @defaultvalue 1
     * @public
     */
    step: number;
    /**
     * Defines the value state of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.valueState
     * @type {sap.ui.webc.base.types.ValueState}
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component is required.
     *
     * @name sap.ui.webc.main.StepInput.prototype.required
     * @type {boolean}
     * @defaultvalue false
     * @public
     */
    required: boolean;
    /**
     * Determines whether the component is displayed as disabled.
     *
     * @name sap.ui.webc.main.StepInput.prototype.disabled
     * @type {boolean}
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Determines whether the component is displayed as read-only.
     *
     * @name sap.ui.webc.main.StepInput.prototype.readonly
     * @type {boolean}
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines a short hint, intended to aid the user with data entry when the
     * component has no value.
     *
     * <br><br>
     * <b>Note:</b> When no placeholder is set, the format pattern is displayed as a placeholder.
     * Passing an empty string as the value of this property will make the component appear empty - without placeholder or format pattern.
     *
     * @name sap.ui.webc.main.StepInput.prototype.placeholder
     * @type {string}
     * @defaultvalue undefined
     * @public
     */
    placeholder?: string;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @name sap.ui.webc.main.StepInput.prototype.name
     * @type {string}
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Determines the number of digits after the decimal point of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.valuePrecision
     * @type {sap.ui.webc.base.types.Integer}
     * @defaultvalue 0
     * @public
     */
    valuePrecision: number;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.accessibleName
     * @type {string}
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @name sap.ui.webc.main.StepInput.prototype.accessibleNameRef
     * @type {string}
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    _decIconDisabled: boolean;
    _incIconDisabled: boolean;
    focused: boolean;
    _inputFocused: boolean;
    _previousValue: number;
    _waitTimeout: number;
    _speed: number;
    _btnDown: boolean;
    _spinTimeoutId: Timeout;
    _spinStarted: boolean;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * @type {HTMLElement}
     * @slot
     * @name sap.ui.webc.main.StepInput.prototype.valueStateMessage
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     *
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    _initialValueState?: `${ValueState}`;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    get type(): InputType;
    get decIconTitle(): string;
    get decIconName(): string;
    get incIconTitle(): string;
    get incIconName(): string;
    get _decIconClickable(): boolean;
    get _incIconClickable(): boolean;
    get _isFocused(): boolean;
    get _valuePrecisioned(): string;
    get accInfo(): {
        ariaRequired: boolean;
        ariaLabel: string | undefined;
    };
    get inputAttributes(): {
        min: number | undefined;
        max: number | undefined;
        step: number;
    };
    onBeforeRendering(): void;
    get input(): Input;
    get inputOuter(): Element;
    _onButtonFocusOut(): void;
    _onInputFocusIn(): void;
    _onInputFocusOut(): void;
    _setButtonState(): void;
    _validate(): void;
    _preciseValue(value: number): number;
    _fireChangeEvent(): void;
    /**
     * Value modifier - modifies the value of the component, validates the new value and enables/disables increment and
     * decrement buttons according to the value and min/max values (if set). Fires <code>change</code> event when requested
     *
     * @param {Float} modifier modifies the value of the component with the given modifier (positive or negative)
     * @param {boolean} fireChangeEvent if <code>true</code>, fires <code>change</code> event when the value is changed
     */
    _modifyValue(modifier: number, fireChangeEvent?: boolean): void;
    _incValue(e: CustomEvent): void;
    _decValue(e: CustomEvent): void;
    _onInputChange(): void;
    _onfocusin(): void;
    _onfocusout(): void;
    _onkeydown(e: KeyboardEvent): void;
    _decSpin(): void;
    _incSpin(): void;
    /**
     * Calculates the time which should be waited until _spinValue function is called.
     */
    _calcWaitTimeout(): number;
    /**
     * Called when the increment or decrement button is pressed and held to set new value.
     * @param {boolean} increment - is this the increment button or not so the values should be spin accordingly up or down
     * @param {boolean} resetVariables - whether to reset the spin-related variables or not
     */
    _spinValue(increment: boolean, resetVariables?: boolean): void;
    /**
    * Resets spin process
    */
    _resetSpin(): void;
    /**
    * Resets spin process when mouse outs + or - buttons
    */
    _resetSpinOut(): void;
}
export default StepInput;
