import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import SemanticColor from "./types/SemanticColor.js";
import ListItemType from "./types/ListItemType.js";
import type { ITab } from "./TabContainer.js";
import TabInStripTemplate from "./generated/templates/TabInStripTemplate.lit.js";
import TabInOverflowTemplate from "./generated/templates/TabInOverflowTemplate.lit.js";
/**
 * @class
 * The <code>ui5-tab</code> represents a selectable item inside a <code>ui5-tabcontainer</code>.
 * It defines both the item in the tab strip (top part of the <code>ui5-tabcontainer</code>) and the
 * content that is presented to the user once the tab is selected.
 *
 * @abstract
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Tab
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-tab
 * @implements sap.ui.webc.main.ITab
 * @public
 */
declare class Tab extends UI5Element implements ITab, ITabbable {
    /**
     * The text to be displayed for the item.
     * @type {string}
     * @defaultvalue ""
     * @public
     * @name sap.ui.webc.main.Tab.prototype.text
     */
    text: string;
    /**
     * Disabled tabs can't be selected.
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.main.Tab.prototype.disabled
     */
    disabled: boolean;
    /**
     * Represents the "additionalText" text, which is displayed in the tab. In the cases when in the same time there are tabs with icons and tabs without icons, if a tab has no icon the "additionalText" is displayed larger.
     * @type {string}
     * @defaultvalue ""
     * @public
     * @name sap.ui.webc.main.Tab.prototype.additionalText
     */
    additionalText: string;
    /**
     * Defines the icon source URI to be displayed as graphical element within the component.
     * The SAP-icons font provides numerous built-in icons.
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     *
     * @type {string}
     * @defaultvalue ""
     * @public
     * @name sap.ui.webc.main.Tab.prototype.icon
     */
    icon: string;
    /**
     * Defines the component's design color.
     * <br><br>
     * The design is applied to:
     * <ul>
     * <li>the component icon</li>
     * <li>the <code>text</code> when the component overflows</li>
     * <li>the tab selection line</li>
     * </ul>
     *
     * <br><br>
     * Available designs are: <code>"Default"</code>, <code>"Neutral"</code>, <code>"Positive"</code>, <code>"Critical"</code> and <code>"Negative"</code>.
     *
     * <br><br>
     * <b>Note:</b> The design depends on the current theme.
     * @type {sap.ui.webc.main.types.SemanticColor}
     * @defaultvalue "Default"
     * @public
     * @name sap.ui.webc.main.Tab.prototype.design
     */
    design: `${SemanticColor}`;
    /**
     * Specifies if the component is selected.
     *
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.main.Tab.prototype.selected
     */
    selected: boolean;
    _selected: boolean;
    _realTab: Tab;
    _isTopLevelTab: boolean;
    /**
     * Holds the content associated with this tab.
     *
     * @type {Node[]}
     * @public
     * @slot
     * @name sap.ui.webc.main.Tab.prototype.default
     */
    content: Array<Node>;
    /**
     * Defines hierarchies with nested sub tabs.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-tab</code> and <code>ui5-tab-separator</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITab[]}
     * @public
     * @slot subTabs
     * @name sap.ui.webc.main.Tab.prototype.subTabs
     */
    subTabs: Array<ITab>;
    _isInline?: boolean;
    _mixedMode?: boolean;
    _getElementInStrip?: () => ITab | null;
    _individualSlot: string;
    static i18nBundle: I18nBundle;
    set _tabIndex(val: string);
    get _tabIndex(): string;
    get displayText(): string;
    get isSeparator(): boolean;
    get stripPresentation(): object;
    get overflowPresentation(): object;
    get stableDomRef(): string;
    get requiresExpandButton(): boolean;
    get isSingleClickArea(): boolean;
    get isTwoClickArea(): boolean;
    get isOnSelectedTabPath(): boolean;
    get _effectiveSlotName(): string;
    get _defaultSlotName(): "" | "disabled-slot";
    get _hasOwnContent(): boolean;
    /**
     * Returns the DOM reference of the tab that is placed in the header.
     * <b>Note:</b> Tabs, placed in the <code>subTabs</code> slot of other tabs are not shown in the header. Calling this method on such tabs will return <code>null</code>.
     * <b>Note:</b> If you need a DOM ref to the tab content please use the <code>getDomRef</code> method.
     *
     * @function
     * @public
     * @name sap.ui.webc.main.Tab.prototype.getTabInStripDomRef
     * @since 1.0.0-rc.16
     */
    getTabInStripDomRef(): ITab | null;
    getFocusDomRef(): HTMLElement | undefined;
    get isMixedModeTab(): boolean | undefined;
    get isTextOnlyTab(): boolean;
    get isIconTab(): boolean;
    get effectiveDisabled(): true | undefined;
    get effectiveSelected(): boolean;
    get effectiveHidden(): boolean;
    get tabs(): Array<Tab>;
    get ariaLabelledBy(): string;
    get stripClasses(): {
        itemClasses: string;
        additionalTextClasses: string;
    };
    get additionalTextClasses(): string;
    get expandButtonTitle(): string;
    get _roleDescription(): string | undefined;
    get _ariaHasPopup(): "menu" | undefined;
    get semanticIconName(): "error" | "alert" | "sys-enter-2" | null;
    get _designDescription(): string | null;
    get semanticIconClasses(): string;
    get overflowClasses(): string;
    get overflowState(): ListItemType.Inactive | ListItemType.Active;
    static get stripTemplate(): typeof TabInStripTemplate;
    static get overflowTemplate(): typeof TabInOverflowTemplate;
    static onDefine(): Promise<void>;
}
export default Tab;
