import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { StyleData } from "@ui5/webcomponents-base/dist/types.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-up.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
import Button from "./Button.js";
import type Tab from "./Tab.js";
import type { ListItemClickEventDetail } from "./List.js";
import type CustomListItem from "./CustomListItem.js";
import ResponsivePopover from "./ResponsivePopover.js";
import TabContainerTabsPlacement from "./types/TabContainerTabsPlacement.js";
import SemanticColor from "./types/SemanticColor.js";
import TabContainerBackgroundDesign from "./types/TabContainerBackgroundDesign.js";
import TabLayout from "./types/TabLayout.js";
import TabsOverflowMode from "./types/TabsOverflowMode.js";
interface ITab extends UI5Element {
    isSeparator: boolean;
    getTabInStripDomRef: () => ITab | null;
    stableDomRef: string;
    additionalText?: string;
    design?: `${SemanticColor}`;
    disabled?: boolean;
    icon?: string;
    isSingleClickArea?: boolean;
    requiresExpandButton?: boolean;
    selected?: boolean;
    subTabs?: Array<ITab>;
    tabs?: Array<ITab>;
    text?: string;
    _tabIndex?: string;
    _hasOwnContent?: boolean;
    _level?: number;
    _selected?: boolean;
    _getElementInStrip?: () => ITab | null;
    _isInline?: boolean;
    _mixedMode?: boolean;
    _posinset?: number;
    _setsize?: number;
    _realTab?: Tab;
    _isTopLevelTab?: boolean;
    _style?: Record<string, any>;
}
type TabContainerTabSelectEventDetail = {
    tab: Tab;
    tabIndex: number;
};
interface TabContainerTabInOverflow extends CustomListItem {
    _realTab: Tab;
}
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-tabcontainer</code> represents a collection of tabs with associated content.
 * Navigation through the tabs changes the content display of the currently active content area.
 * A tab can be labeled with text only, or icons with text.
 *
 * <h3>Structure</h3>
 *
 * The <code>ui5-tabcontainer</code> can hold two types of entities:
 * <ul>
 * <li><code>ui5-tab</code> - contains all the information on an item (text and icon)</li>
 * <li><code>ui5-tab-separator</code> - used to separate tabs with a line</li>
 * </ul>
 *
 * <h3>Hierarchies</h3>
 * Multiple sub tabs could be placed underneath one main tab. Nesting allows deeper hierarchies with indentations
 * to indicate the level of each nested tab. When a tab has both sub tabs and own content its click area is split
 * to allow the user to display the content or alternatively to expand / collapse the list of sub tabs.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-tabcontainer</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>content - Used to style the content of the component</li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/TabContainer";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/Tab";</code> (for <code>ui5-tab</code>)
 * <br>
 * <code>import "@ui5/webcomponents/dist/TabSeparator";</code> (for <code>ui5-tab-separator</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TabContainer
 * @extends sap.ui.webc.base.UI5Element
 * @appenddocs sap.ui.webc.main.Tab sap.ui.webc.main.TabSeparator
 * @tagname ui5-tabcontainer
 * @public
 */
declare class TabContainer extends UI5Element {
    /**
     * Defines whether the tabs are in a fixed state that is not
     * expandable/collapsible by user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TabContainer.prototype.fixed
     * @defaultvalue false
     * @public
     */
    fixed: boolean;
    /**
     * Defines whether the tab content is collapsed.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TabContainer.prototype.collapsed
     * @defaultvalue false
     * @public
     */
    collapsed: boolean;
    /**
     * Defines whether the overflow select list is displayed.
     * <br><br>
     * The overflow select list represents a list, where all tabs are displayed
     * so that it's easier for the user to select a specific tab.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TabContainer.prototype.showOverflow
     * @defaultvalue false
     * @public
     * @deprecated Since the introduction of TabsOverflowMode, overflows will always be visible if there is not enough space for all tabs,
     * all hidden tabs are moved to a select list in the respective overflows and are accessible via the <code>overflowButton</code> and / or <code>startOverflowButton</code> slots.
     */
    showOverflow: boolean;
    /**
     * Defines the alignment of the content and the <code>additionalText</code> of a tab.
     *
     * <br>
     * <b>Note:</b>
     * The content and the <code>additionalText</code> would be displayed vertically by default,
     * but when set to <code>Inline</code>, they would be displayed horizontally.
     *
     * @type {sap.ui.webc.main.types.TabLayout}
     * @name sap.ui.webc.main.TabContainer.prototype.tabLayout
     * @defaultvalue "Standard"
     * @public
     */
    tabLayout: `${TabLayout}`;
    /**
     * Defines the overflow mode of the header (the tab strip). If you have a large number of tabs, only the tabs that can fit on screen will be visible.
     * All other tabs that can 't fit on the screen are available in an overflow tab "More".
     *
     * <br>
     * <b>Note:</b>
     * Only one overflow at the end would be displayed by default,
     * but when set to <code>StartAndEnd</code>, there will be two overflows on both ends, and tab order will not change on tab selection.
     *
     * @type {sap.ui.webc.main.types.TabsOverflowMode}
     * @name sap.ui.webc.main.TabContainer.prototype.tabsOverflowMode
     * @defaultvalue "End"
     * @since 1.1.0
     * @public
     */
    tabsOverflowMode: `${TabsOverflowMode}`;
    /**
     * Sets the background color of the Tab Container's header as <code>Solid</code>, <code>Transparent</code>, or <code>Translucent</code>.
     *
     * @type {sap.ui.webc.main.types.TabContainerBackgroundDesign}
     * @name sap.ui.webc.main.TabContainer.prototype.headerBackgroundDesign
     * @defaultvalue "Solid"
     * @since 1.10.0
     * @public
     */
    headerBackgroundDesign: `${TabContainerBackgroundDesign}`;
    /**
     * Sets the background color of the Tab Container's content as <code>Solid</code>, <code>Transparent</code>, or <code>Translucent</code>.
     *
     * @type {sap.ui.webc.main.types.TabContainerBackgroundDesign}
     * @name sap.ui.webc.main.TabContainer.prototype.contentBackgroundDesign
     * @defaultvalue "Solid"
     * @since 1.10.0
     * @public
     */
    contentBackgroundDesign: `${TabContainerBackgroundDesign}`;
    /**
     * Defines the placement of the tab strip relative to the actual tabs' content.
     * <br><br>
     * <b>Note:</b> By default the tab strip is displayed above the tabs' content area and this is the recommended
     * layout for most scenarios. Set to <code>Bottom</code> only when the component is at the
     * bottom of the page and you want the tab strip to act as a menu.
     *
     * @type {sap.ui.webc.main.types.TabContainerTabsPlacement}
     * @name sap.ui.webc.main.TabContainer.prototype.tabsPlacement
     * @defaultvalue "Top"
     * @since 1.0.0-rc.7
     * @private
     */
    tabsPlacement: `${TabContainerTabsPlacement}`;
    _selectedTab: Tab;
    _animationRunning: boolean;
    _contentCollapsed: boolean;
    _startOverflowText: string;
    _endOverflowText: string;
    _overflowItems: Array<ITab>;
    _width?: number;
    /**
     * Defines the tabs.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-tab</code> and <code>ui5-tab-separator</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITab[]}
     * @public
     * @slot items
     * @name sap.ui.webc.main.TabContainer.prototype.default
     */
    items: Array<ITab>;
    /**
     * Defines the button which will open the overflow menu. If nothing is provided to this slot,
     * the default button will be used.
     *
     * @type {sap.ui.webc.main.IButton}
     * @public
     * @slot
     * @since 1.0.0-rc.9
     * @name sap.ui.webc.main.TabContainer.prototype.overflowButton
     */
    overflowButton: Array<Button>;
    /**
     * Defines the button which will open the start overflow menu if available. If nothing is provided to this slot,
     * the default button will be used.
     *
     * @type {sap.ui.webc.main.IButton}
     * @public
     * @slot
     * @since 1.1.0
     * @name sap.ui.webc.main.TabContainer.prototype.startOverflowButton
     */
    startOverflowButton: Array<Button>;
    _itemNavigation: ItemNavigation;
    _allItemsAndSubItems?: Array<ITab>;
    responsivePopover?: ResponsivePopover;
    _handleResizeBound: () => void;
    static registerTabStyles(styles: StyleData): void;
    static registerStaticAreaTabStyles(styles: StyleData): void;
    static i18nBundle: I18nBundle;
    constructor();
    onBeforeRendering(): void;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _handleResize(): void;
    _setItemsPrivateProperties(items: Array<ITab>): void;
    _onHeaderFocusin(e: FocusEvent): void;
    _onTabStripClick(e: Event): Promise<void>;
    _onTabExpandButtonClick(e: Event): Promise<void>;
    _setPopoverInitialFocus(): void;
    _getSelectedTabInOverflow(): TabContainerTabInOverflow;
    _getFirstFocusableItemInOverflow(): TabContainerTabInOverflow;
    _onTabStripKeyDown(e: KeyboardEvent): void;
    _onTabStripKeyUp(e: KeyboardEvent): void;
    _onHeaderItemSelect(tab: HTMLElement): void;
    _onOverflowListItemClick(e: CustomEvent<ListItemClickEventDetail>): Promise<void>;
    /**
     * Returns all slotted tabs and their subTabs in a flattened array.
     * The order of tabs is depth-first. For example, given the following slotted elements:
     * <pre><code>
     * 	&lt;ui5-tabcontainer&gt;
     * 		&lt;ui5-tab id="First" text="First"&gt;
     * 			...
     * 			&lt;ui5-tab slot="subTabs" id="Nested" text="Nested"&gt;...&lt;/ui5-tab&gt;
     * 		&lt;/ui5-tab&gt;
     * 		&lt;ui5-tab id="Second" text="Second"&gt;...&lt;/ui5-tab&gt;
     * 		&lt;ui5-tab-separator id="sep"&gt;&lt;/ui5-tab-separator&gt;
     * 		&lt;ui5-tab id="Third" text="Third"&gt;...&lt;/ui5-tab&gt;
     * 	&lt;/ui5-tabcontainer&gt;
     * </code></pre>
     * Calling <code>allItems</code> on this TabContainer will return the instances in the following order:
     * <code>[ ui5-tab#First, ui5-tab#Nested, ui5-tab#Second, ui5-tab-separator#sep, ui5-tab#Third ]</code>
     * @public
     * @readonly
     * @name sap.ui.webc.main.TabContainer.prototype.allItems
     * @returns {sap.ui.webc.main.ITab[]}
     */
    get allItems(): ITab[];
    _getAllSubItems(items: Array<ITab>, result?: Array<ITab>, level?: number): ITab[];
    _onItemSelect(selectedTabId: string): void;
    toggleAnimated(selectedTab: Tab, previousTab: Tab): Promise<void>;
    toggle(selectedTab: Tab, previousTab: Tab): void;
    /**
     * Fires the <code>tab-select</code> event and changes the internal reference for the currently selected tab.
     * If the event is prevented, the current tab is not changed.
     * @private
     *
     * @param {sap.ui.webc.main.ITab} selectedTab selected tab instance
     * @param {number} selectedTabIndex selected tab index for an array containing all tabs and sub tabs. <b>Note:</b> Use the method <code>allTabs</code> to get this array.
     * @returns {boolean} true if the tab selection is successful, false if it was prevented
     */
    selectTab(selectedTab: Tab, selectedTabIndex: number): boolean;
    slideContentDown(element: HTMLElement): Promise<void | Error>;
    slideContentUp(element: HTMLElement): Promise<void | Error>;
    _onOverflowClick(e: Event): Promise<void>;
    _addStyleIndent(tabs: Array<ITab>): void;
    _onOverflowKeyDown(e: KeyboardEvent): Promise<void>;
    _setItemsForStrip(): void;
    _getRootTab(tab: Tab): Tab;
    _updateEndOverflow(itemsDomRefs: Array<ITab>): void;
    _updateStartAndEndOverflow(itemsDomRefs: Array<ITab>): void;
    _hasStartOverflow(containerWidth: number, itemsDomRefs: Array<ITab>, selectedItemIndexAndWidth: {
        width: number;
        index: number;
    }): boolean;
    _hasEndOverflow(containerWidth: number, itemsDomRefs: Array<ITab>, selectedItemIndexAndWidth: {
        width: number;
        index: number;
    }): boolean;
    _getItemWidth(itemDomRef: HTMLElement): number;
    _getSelectedItemIndexAndWidth(itemsDomRefs: Array<ITab>, selectedTabDomRef: ITab): {
        index: number;
        width: number;
    };
    _findFirstVisibleItem(itemsDomRefs: Array<ITab>, containerWidth: number, selectedItemWidth: number, startIndex?: number): number;
    _findLastVisibleItem(itemsDomRefs: Array<ITab>, containerWidth: number, selectedItemWidth: number, startIndex?: number): number;
    get isModeStartAndEnd(): boolean;
    _updateOverflowCounters(): void;
    _getFocusableRefs(): Button[];
    _getHeader(): HTMLElement;
    _getTabs(): Array<Tab>;
    get hasSubTabs(): boolean;
    _getTabStrip(): HTMLElement;
    _getStartOverflow(): HTMLElement;
    _getEndOverflow(): HTMLElement;
    _getStartOverflowBtnDOM(): Button | null;
    _getEndOverflowBtnDOM(): Button | null;
    _respPopover(): Promise<ResponsivePopover>;
    _closeRespPopover(): Promise<void>;
    get classes(): {
        root: {
            "ui5-tc-root": boolean;
            "ui5-tc--textOnly": boolean;
            "ui5-tc--withAdditionalText": boolean;
            "ui5-tc--standardTabLayout": boolean;
        };
        header: {
            "ui5-tc__header": boolean;
        };
        tabStrip: {
            "ui5-tc__tabStrip": boolean;
        };
        separator: {
            "ui5-tc__separator": boolean;
        };
        content: {
            "ui5-tc__content": boolean;
            "ui5-tc__content--collapsed": boolean;
        };
    };
    get mixedMode(): boolean;
    get textOnly(): boolean;
    get withAdditionalText(): boolean;
    get standardTabLayout(): boolean;
    get previousIconACCName(): string;
    get nextIconACCName(): string;
    get overflowMenuTitle(): string;
    get tabsAtTheBottom(): boolean;
    get overflowMenuIcon(): "slim-arrow-up" | "slim-arrow-down";
    get overflowButtonText(): string;
    get popoverCancelButtonText(): string;
    get accInvisibleText(): string;
    get tablistAriaDescribedById(): string | undefined;
    get shouldAnimate(): boolean;
    static onDefine(): Promise<void>;
}
export default TabContainer;
export type { ITab, TabContainerTabSelectEventDetail, };
