var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var TableCell_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import { getI18nBundle } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import TableCellTemplate from "./generated/templates/TableCellTemplate.lit.js";
// Styles
import tableCellStyles from "./generated/themes/TableCell.css.js";
// Texts
import { ARIA_LABEL_EMPTY_CELL, } from "./generated/i18n/i18n-defaults.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table-cell</code> component defines the structure of the data in a single <code>ui5-table</code> cell.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-table-cell</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>cell - Used to style the native <code>td</code> element</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TableCell
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table-cell
 * @implements sap.ui.webc.main.ITableCell
 * @public
 */
let TableCell = TableCell_1 = class TableCell extends UI5Element {
    static async onDefine() {
        TableCell_1.i18nBundle = await getI18nBundle("@ui5/webcomponents");
    }
    get cellContent() {
        return this.getSlottedNodes("content");
    }
    get ariaLabelEmptyCellText() {
        return TableCell_1.i18nBundle.getText(ARIA_LABEL_EMPTY_CELL);
    }
};
__decorate([
    property({ type: Boolean })
], TableCell.prototype, "lastInRow", void 0);
__decorate([
    property({ type: Boolean })
], TableCell.prototype, "popined", void 0);
__decorate([
    property({ type: Boolean })
], TableCell.prototype, "_popinedInline", void 0);
__decorate([
    slot({ type: HTMLElement, "default": true })
], TableCell.prototype, "content", void 0);
TableCell = TableCell_1 = __decorate([
    customElement({
        tag: "ui5-table-cell",
        renderer: litRender,
        template: TableCellTemplate,
        styles: tableCellStyles,
    })
], TableCell);
TableCell.define();
export default TableCell;
//# sourceMappingURL=TableCell.js.map