import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ITableRow, TableColumnInfo } from "./Table.js";
import TableMode from "./types/TableMode.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table-group-row</code> component represents a group row in the <code>ui5-table</code>.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-table-group-row</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>group-row - Used to style the native <code>tr</code> element.</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TableGroupRow
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table-group-row
 * @since 1.0.0-rc.15
 * @implements sap.ui.webc.main.ITableRow
 * @public
 */
declare class TableGroupRow extends UI5Element implements ITableRow, ITabbable {
    /**
     * Defines the mode of the row
     *
     * <br><br>
     * <b>Note:</b>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>SingleSelect</code></li>
     * <li><code>MultiSelect</code></li>
     * </ul>
     * @type {sap.ui.webc.main.types.TableMode}
     * @defaultvalue "None"
     * @private
     */
    mode: `${TableMode}`;
    _columnsInfo: Array<TableColumnInfo>;
    _tabIndex: string;
    _busy: boolean;
    _ariaPosition: string;
    selected: boolean;
    _tabbables: Array<HTMLElement>;
    _columnsInfoString: string;
    /**
     * Defines the text of the component.
     * <br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.TableGroupRow.prototype.default
     * @slot
     * @public
     */
    static i18nBundle: I18nBundle;
    _colSpan?: number;
    get colSpan(): number | undefined;
    get ariaLabelText(): string;
    visibleColCount(): number;
    onBeforeRendering(): void;
    _onfocusin(e: FocusEvent): void;
    static onDefine(): Promise<void>;
}
export default TableGroupRow;
