import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
type TimePickerClockChangeEventDetail = {
    value: number;
    stringValue: string;
    finalChange: boolean;
};
type TimePickerClockItem = {
    angle?: number;
    item?: string;
    innerItem?: string;
    outerStyles?: object;
    innerStyles?: object;
};
type TimePickerClockSelection = {
    showMarker: boolean;
    itemClasses?: string;
    innerItemClasses?: string;
};
type TimePickerClockDimensions = {
    radius: number;
    centerX: number;
    centerY: number;
    dotHeight: number;
    numberHeight: number;
    outerMax: number;
    outerMin: number;
    innerMax: number;
    innerMin: number;
    offsetX: number;
    offsetY: number;
};
type TimePickerClockSelectedItem = TimePickerClockItem & TimePickerClockSelection;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-time-picker-clock</code> allows selecting of hours,minutes or seconds (depending on property set).
 * The component supports interactions with mouse, touch and mouse wheel.
 * Depending on settings, the clock can display only outer set of items (when the clock displays hours in 12-hour mode,
 * minutes or seconds), or outer and inner sets of items (when the clock displays hours in 24-hours mode).
 * The step for displaying or selecting of items can be configured.
 *
 * <code>ui5-time-picker-clock</code> is used as part of <code>ui5-time-selection-clocks</code> component, which
 * is used in <code>ui5-time-picker</code> component respectively.
 *
 * <h3>Usage</h3>
 *
 * <code>ui5-time-picker-clock</code> can display hours, minutes or seconds
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/TimePickerClock.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TimePickerClock
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-time-picker-clock
 * @since 1.15.0
 * @private
 */
declare class TimePickerClock extends UI5Element {
    /**
     * Determines whether the component is displayed as disabled.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.disabled
     * @type {boolean}
     * @defaultvalue false
     */
    disabled: boolean;
    /**
     * Determines whether the component is active (visible).
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.active
     * @type {boolean}
     * @defaultvalue false
     */
    active: boolean;
    /**
     * Minimum item value for the outer circle of the clock.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.itemMin
     * @type {integer}
     * @defaultvalue -1
     */
    itemMin: number;
    /**
     * Maximum item value for the outer circle of the clock.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.itemMax
     * @type {integer}
     * @defaultvalue -1
     */
    itemMax: number;
    /**
     * If set to <code>true</code>, an inner circle is displayed.
     * The first item value of the inner circle will be itemMax + 1
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.showInnerCircle
     * @type {boolean}
     * @defaultvalue false
     */
    showInnerCircle: boolean;
    /**
     * Label of the clock dial - for example, 'Hours', 'Minutes', or 'Seconds'.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.label
     * @type {string}
     * @defaultvalue undefined
     */
    label?: string;
    /**
     * If set to <code>true</code>, a surrounding circle with markers (dots) will be hidden.
     * (for example, on the 'Minutes' clock-dial, markers represent minutes).
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.hideFractions
     * @type {boolean}
     * @defaultvalue false
     */
    hideFractions: boolean;
    /**
     * If provided, this will replace the last item displayed. If there is only one (outer) circle,
     * the last item from outer circle will be replaced; if there is an inner circle too, the last
     * item of inner circle will be replaced. Usually, the last item '24' is replaced with '0'.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.lastItemReplacement
     * @type {integer}
     * @defaultvalue -1
     */
    lastItemReplacement: number;
    /**
     * Prepend with zero flag. If <code>true</code>, values less than 10 will be prepend with 0.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.prependZero
     * @type {boolean}
     * @defaultvalue false
     */
    prependZero: boolean;
    /**
     * The currently selected value of the clock.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.selectedValue
     * @type {integer}
     * @defaultvalue -1
     */
    selectedValue: number;
    /**
     * The step for displaying of one unit of items.
     * 1 means 1/60 of the circle.
     * The default display step is 5 which means minutes and seconds are displayed as "0", "5", "10", etc.
     * For hours the display step must be set to 1.
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.displayStep
     * @type {integer}
     * @defaultvalue 5
     */
    displayStep: number;
    /**
     * The step for selection of items.
     * 1 means 1 unit:
     * - if the clock displays hours - 1 unit = 1 hour
     * - if the clock displays minutes/seconds - 1 unit = 1 minute/second
     *
     * @name sap.ui.webc.main.TimePickerClock.prototype.valueStep
     * @type {integer}
     * @defaultvalue 1
     */
    valueStep: number;
    /**
     * Defines the currently available Time Picker Clock items depending on Clock setup.
     *
     * @type {Array}
     */
    _items: Array<TimePickerClockItem>;
    /**
     * Defines the currently selected Time Picker Clock item.
     *
     * @type {TimePickerClockSelectedItem}
     */
    _selectedItem: TimePickerClockSelectedItem;
    /**
     * Keeps variables used in interaction calculations.
     *
     * @type {TimePickerClockDimensions}
     */
    _dimensionParameters: TimePickerClockDimensions;
    /**
     * Mousedown or Touchstart event flag.
     *
     * @type {boolean}
     * @defaultvalue false
     */
    _mouseOrTouchDown: boolean;
    /**
     * Cancel Mouseout flag.
     *
     * @type {boolean}
     * @defaultvalue false
     */
    _cancelTouchOut: boolean;
    /**
     * Calculated selected value of the clock during interactions.
     *
     * @type {integer}
     * @defaultvalue -1
     */
    _selectedValue: number;
    /**
     * Selected value of the clock during interactions.
     *
     * @type {integer}
     * @defaultvalue -1
     */
    _movSelectedValue: number;
    /**
     * Hovered value of the clock during interactions.
     *
     * @type {integer}
     * @defaultvalue -1
     */
    _hoveredValue: number;
    /**
     * Previously hovered value of the clock during interactions.
     *
     * @type {integer}
     * @defaultvalue -1
     */
    _prevHoveredValue: number;
    /**
     * Animation in progress flag.
     *
     * @type {boolean}
     * @defaultvalue false
     */
    _animationInProgress: boolean;
    _fnOnMouseOutUp: () => void;
    constructor();
    get classes(): ClassMap;
    onEnterDOM(): void;
    onExitDOM(): void;
    onBeforeRendering(): void;
    /**
     * Returns the real value of the passed clock item, if the replacement must be done, returns the replaced value.
     *
     * @param {number} value The value of the clock item
     * @returns {number} The real/replaced value
     */
    _fixReplacementValue(value: number): number;
    /**
     * Updates internal selected value object constructed for rendering purposes.
     *
     * @param {number} value currently selected value.
     */
    _updateSelectedValueObject(value: number): void;
    /**
     * Prepares clock items objects according to current clock settings. Item objects are used for rendering purposes.
     */
    _prepareClockItems(): void;
    /**
     * Returns the DOM Reference of the clock cover element
     *
     * @returns {HTMLElement} the DOM Reference
     */
    _getClockCoverContainerDomRef(): Element | null | undefined;
    /**
     * Returns the real max value of clock items, taking in count if there is inner circle or not.
     *
     * @returns {number} max value
     */
    _getMaxValue(): number;
    /**
     * Calculates the outer height of a HTML element.
     *
     * @param {HTMLElement} element The element which outer height to be calculated
     * @returns {number} Outer height of the passed HTML element
     */
    _outerHeight(element: HTMLElement): number;
    /**
     * Returns the Id of the DOM element of the clock item that display specific value.
     *
     * @param {number} value The value of the clock item
     * @returns {string} Id of the clock item element
     */
    _hoveredId(value: number): string;
    /**
     * Returns provided value as string. Padding with additional zero is applied if necessary.
     *
     * @param {number} value The value that should be returned as string
     * @returns {string} The value as string
     */
    _getStringValue(value: number): string;
    /**
     * Calculates dimension variables necessary for determining of item selection.
     *
     * @returns {TimePickerClockDimensions} Dimensions object
     */
    _calculateDimensions(): void;
    /**
     * Calculates selected and hovered values based on click/touch position.
     *
     * @param {number} x X position of click/touch returned by the event
     * @param {number} y Y position of click/touch returned by the event
     */
    _calculatePosition(x: number, y: number): void;
    /**
     * Does the animation between the old and the new value of the clock. Can be skipped with setting the second parameter to true.
     *
     * @param {number} newValue the new value that must be set
     * @param {boolean} skipAnimation whether to skip the animation
     */
    _changeValueAnimation(newValue: number, skipAnimation?: boolean): void;
    /**
     * Does the animation step between old and new selected values.
     *
     * @param {number} firstSelected first/current value to move from
     * @param {number} lastSelected last value to move to
     * @param {number} direction direction of the animation
     * @param {number} maxValue max clock value
     * @param {number} newValue new value
     * @param {number} delay delay of the single step
     */
    _selectNextNumber(firstSelected: number, lastSelected: number, direction: number, maxValue: number, newValue: number, delay: number): void;
    /**
     * Mousewheel handler. Increases/decreases value of the clock.
     *
     * @param {boolean} increase whether to increase or decrease the value
     */
    _modifyValue(increase: boolean): void;
    /**
     * Sets new selected value, fires change event and updates selected value object used for rendering purposes.
     *
     * @param {number} value
     */
    _setSelectedValue(value: number): void;
    /**
     * TouchStart/MouseDown event handler.
     *
     * @param {event} evt Event object
     */
    _onTouchStart(evt: Event): void;
    /**
     * TouchMove/MouseMove event handler.
     *
     * @param {event} evt Event object
     */
    _onTouchMove(evt: Event): void;
    /**
     * TouchEnd/MouseUp event handler.
     *
     * @param {event} evt Event object
     */
    _onTouchEnd(evt: Event): void;
    /**
     * Mouse Wheel event handler.
     *
     * @param {WheelEvent} evt Event object
     */
    _onMouseWheel(evt: WheelEvent): void;
    /**
     * MouseOut event handler.
     */
    _onMouseOut(): void;
}
export default TimePickerClock;
export type { TimePickerClockChangeEventDetail };
