/// <reference types="openui5" />
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import DateFormat from "@ui5/webcomponents-localization/dist/DateFormat.js";
import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
import CalendarType from "@ui5/webcomponents-base/dist/types/CalendarType.js";
import SegmentedButton from "./SegmentedButton.js";
type TimePickerComponentIndexMap = {
    hours: number;
    minutes: number;
    seconds: number;
};
type TimeSelectionPeriodProperties = {
    label: string;
    pressed: boolean;
};
type TimeSelectionChangeEventDetail = {
    value: string | undefined;
    valid: boolean;
};
type TimePickerEntityAttributes = {
    min: number;
    max: number;
    step: number;
};
type TimePickerEntityProperties = {
    label: string;
    entity?: string;
    itemMin?: number;
    itemMax?: number;
    value: number;
    stringValue?: string;
    textValue?: string;
    displayStep?: number;
    lastItemReplacement?: number;
    showInnerCircle?: boolean;
    prependZero: boolean;
    active?: boolean;
    hasSeparator?: boolean;
    attributes?: TimePickerEntityAttributes;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-time-picker-internals</code> is helper component that contains shared methods used in <code>ui5-time-selection-clocks</code>
 * and <ui5-time-selection-inputs> components and should not be used separately.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TimePickerInternals
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-time-picker-internals
 * @since 1.15.0
 * @private
 */
declare class TimePickerInternals extends UI5Element {
    /**
     * Defines a formatted time value.
     *
     * @type {string}
     * @name sap.ui.webc.main.TimePickerInternals.prototype.value
     * @defaultvalue undefined
     * @public
     */
    value?: string;
    /**
     * Determines the format, displayed in the input field.
     *
     * Example:
     * HH:mm:ss -> 11:42:35
     * hh:mm:ss a -> 2:23:15 PM
     * mm:ss -> 12:04 (only minutes and seconds)

     * @type {string}
     * @name sap.ui.webc.main.TimePickerInternals.prototype.formatPattern
     * @defaultvalue ""
     * @public
     */
    formatPattern: string;
    /**
     * The index of the active Clock/TogleSpinButton.
     *
     * @type {integer}
     * @defaultvalue 0
     * @private
     */
    _activeIndex: number;
    /**
     * Contains calendar type.
     *
     * @type {CalendarType}
     * @private
     */
    _calendarType: CalendarType;
    /**
     * Contains currently available Time Picker components depending on time format.
     *
     * @type {Array}
     */
    _entities: Array<TimePickerEntityProperties>;
    /**
     * Contains component-to-index map.
     *
     * @type {TimePickerComponentIndexMap}
     * @private
     */
    _componentMap: TimePickerComponentIndexMap;
    /**
     * Contains currently available Button components depending on time format.
     *
     * @type {Array}
     * @private
     */
    _periods: Array<TimeSelectionPeriodProperties>;
    /**
     * Id of the cooldown interval
     *
     * @type {ReturnType}
     */
    _typeCooldownId?: ReturnType<typeof setTimeout>;
    /**
     * Exact match number buffer
     *
     * @type {integer}
     */
    _exactMatch?: number;
    /**
     * Buffer for entered by keyboard numbers
     *
     * @type {string}
     */
    _keyboardBuffer: string;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    get _hoursConfiguration(): import("./timepicker-utils/TimeSlider.js").HoursConfiguration;
    get _zeroPaddedHours(): boolean;
    get _neededComponents(): boolean[];
    get _hasHoursComponent(): boolean;
    get _hasMinutesComponent(): boolean;
    get _hasSecondsComponent(): boolean;
    get _hasPeriodsComponent(): boolean;
    get dateValue(): Date;
    get validDateValue(): Date;
    get periodsArray(): string[];
    get _hours(): string;
    get _minutes(): string;
    get _seconds(): string;
    get _period(): string | undefined;
    get _formatPattern(): string;
    get _isPattern(): boolean;
    get hoursLabel(): string;
    get minutesLabel(): string;
    get secondsLabel(): string;
    get clockDialAriaLabel(): string;
    setValue(date: Date): void;
    isValid(value: string): true | Date | Date[] | import("sap/ui/core/date/UI5Date").default | import("sap/ui/core/date/UI5Date").default[];
    normalizeValue(value: string): string;
    getFormat(): DateFormat;
    formatValue(date: Date): string;
    _componentKey(name: string): keyof TimePickerComponentIndexMap;
    _indexFromName(name: string): number;
    /**
     * Returns name of the clock or button from the id of the event target.
     *
     * @returns {string | undefined} name of the clock/button
     */
    _getNameFromId(id: string): string | undefined;
    /**
     * Returns index of the clock or button from the id of the event target.
     *
     * @returns {number} index of the clock/button
     */
    _getIndexFromId(id: string): number;
    /**
     * Changes hours value.
     *
     * @param {hours} number new hours value
     */
    _hoursChange(hours: number): void;
    /**
     * Changes minutes value.
     *
     * @param {minutes} number new minutes value
     */
    _minutesChange(minutes: number): void;
    /**
     * Changes seconds value.
     *
     * @param {seconds} number new seconds value
     */
    _secondsChange(seconds: number): void;
    _buttonAmPm(): SegmentedButton | null | undefined;
    _createPeriodComponent(): void;
    _periodChange(evt: PointerEvent): void;
    _calculatePeriodChange(period: string): void;
    /**
     * Shifts hours value with +/- 12 depending on hour value and day period.
     *
     * @param {number} hours current hours
     * @returns {number} shifted hours
     */
    _shiftHours(hours: number): number;
    /**
     * Clears the currently existing cooldown period and starts new one if requested.
     *
     * @param {boolean} startNewCooldown whether to start new cooldown period after clearing previous one
     */
    _resetCooldown(startNewCooldown: boolean): void;
    /**
     * Starts new cooldown period.
     */
    _startCooldown(): void;
    /**
     * Sets the exact match value. Override if necessary.
     */
    _setExactMatch(): void;
}
export default TimePickerInternals;
export type { TimePickerComponentIndexMap, TimeSelectionChangeEventDetail, };
