import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import TitleLevel from "./types/TitleLevel.js";
import WrappingType from "./types/WrappingType.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-title</code> component is used to display titles inside a page.
 * It is a simple, large-sized text with explicit header/title semantics.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Title";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Title
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-title
 * @public
 */
declare class Title extends UI5Element {
    /**
     * Defines how the text of a component will be displayed when there is not enough space.
     * <br><b>Note:</b> for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * @name sap.ui.webc.main.Title.prototype.wrappingType
     * @type {sap.ui.webc.main.types.WrappingType}
     * @defaultvalue "None"
     * @public
     */
    wrappingType: `${WrappingType}`;
    /**
     * Defines the component level.
     * Available options are: <code>"H6"</code> to <code>"H1"</code>.
     *
     * @name sap.ui.webc.main.Title.prototype.level
     * @type {sap.ui.webc.main.types.TitleLevel}
     * @defaultvalue "H2"
     * @public
     */
    level: `${TitleLevel}`;
    /**
     * Defines the text of the component.
     * This component supports nesting a <code>Link</code> component inside.
     * <br><br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @slot
     * @name sap.ui.webc.main.Title.prototype.default
     * @public
     */
    get normalizedLevel(): string;
    get h1(): boolean;
    get h2(): boolean;
    get h3(): boolean;
    get h4(): boolean;
    get h5(): boolean;
    get h6(): boolean;
}
export default Title;
