import ToggleButton from "./ToggleButton.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-toggle-spin-button</code> is explicitly used in the new design of <code>ui5-time-picker</code>.
 * It extends <code>ui5-toggle-button</code> with some specific accessibility-related properties in order to
 * have spin button look and feel from accessibility point of view. This component should not be used separately.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ToggleSpinButton
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-toggle-spin-button
 * @since 1.15.0
 * @private
 */
declare class ToggleSpinButton extends ToggleButton {
    /**
     * Defines the ARIA valuemin of the component.
     *
     * @name sap.ui.webc.main.ToggleSpinButton.prototype.valueMin
     * @type {Integer}
     * @defaultvalue -1
     */
    valueMin: number;
    /**
     * Defines the ARIA valuemax of the component.
     *
     * @name sap.ui.webc.main.ToggleSpinButton.prototype.valueMax
     * @type {Integer}
     * @defaultvalue -1
     */
    valueMax: number;
    /**
     * Defines the ARIA valuenow of the component.
     *
     * @name sap.ui.webc.main.ToggleSpinButton.prototype.valueNow
     * @type {Integer}
     * @defaultvalue -1
     */
    valueNow: number;
    /**
     * Defines the ARIA valuetext of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.ToggleSpinButton.prototype.valueText
     */
    valueText?: string;
    /**
     * Override of the handler in order to prevent button toggle functionality
     */
    _onclick(): void;
}
export default ToggleSpinButton;
