import ToolbarSeparatorTemplate from "./generated/templates/ToolbarSeparatorTemplate.lit.js";
import ToolbarPopoverSeparatorTemplate from "./generated/templates/ToolbarPopoverSeparatorTemplate.lit.js";
import ToolbarItem from "./ToolbarItem.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-toolbar-separator</code> is an element, used for visual separation between two elements.
 * It takes no space in calculating toolbar items width.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ToolbarSeparator
 * @extends sap.ui.webc.main.ToolbarItem
 * @tagname ui5-toolbar-separator
 * @since 1.17.0
 * @abstract
 * @implements sap.ui.webc.main.IToolbarItem
 * @public
 */
declare class ToolbarSeparator extends ToolbarItem {
    visible: boolean;
    static get toolbarTemplate(): typeof ToolbarSeparatorTemplate;
    static get toolbarPopoverTemplate(): typeof ToolbarPopoverSeparatorTemplate;
    get isSeparator(): boolean;
    get isInteractive(): boolean;
}
export default ToolbarSeparator;
