import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import TreeList from "./TreeList.js";
import ListMode from "./types/ListMode.js";
import type TreeItemBase from "./TreeItemBase.js";
import type { TreeItemBaseToggleEventDetail, TreeItemBaseStepInEventDetail, TreeItemBaseStepOutEventDetail } from "./TreeItemBase.js";
import type { ListItemClickEventDetail, ListItemDeleteEventDetail, ListSelectionChangeEventDetail } from "./List.js";
type TreeItemEventDetail = {
    item: TreeItemBase;
};
type TreeItemToggleEventDetail = TreeItemEventDetail;
type TreeItemMouseoverEventDetail = TreeItemEventDetail;
type TreeItemMouseoutEventDetail = TreeItemEventDetail;
type TreeItemClickEventDetail = TreeItemEventDetail;
type TreeItemDeleteEventDetail = TreeItemEventDetail;
type TreeSelectionChangeEventDetail = {
    selectedItems: Array<TreeItemBase>;
    previouslySelectedItems: Array<TreeItemBase>;
    targetItem: TreeItemBase;
};
type WalkCallback = (item: TreeItemBase, level: number, index: number) => void;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-tree</code> component provides a tree structure for displaying data in a hierarchy.
 *
 * <h3>Usage</h3>
 *
 * <h4>When to use:</h4>
 * <ul>
 * <li>To display hierarchically structured items.</li>
 * <li>To select one or more items out of a set of hierarchically structured items.</li>
 * </ul>
 *
 * <h4>When not to use:</h4>
 * <ul>
 * <li>To display items not hierarchically strcutured. In this case, use the List component.</li>
 * <li>To select one item from a very small number of non-hierarchical items. Select or ComboBox might be more appropriate.</li>
 * <li>The hierarchy turns out to have only two levels. In this case, use List with group items.</li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 *
 * The <code>ui5-tree</code> provides advanced keyboard handling.
 * The user can use the following keyboard shortcuts in order to navigate trough the tree:
 * <ul>
 * <li>[UP/DOWN] - Navigates up and down the tree items that are currently visible.</li>
 * <li>[RIGHT] - Drills down the tree by expanding the tree nodes.</li>
 * <li>[LEFT] - Goes up the tree and collapses the tree nodes.</li>
 * </ul>
 * <br>
 *
 * The user can use the following keyboard shortcuts to perform selection,
 * when the <code>mode</code> property is in use:
 * <ul>
 * <li>[SPACE] - Selects the currently focused item upon keyup.</li>
 * <li>[ENTER]  - Selects the currently focused item upon keydown.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents/dist/Tree.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/TreeItem.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Tree
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-tree
 * @appenddocs sap.ui.webc.main.TreeItem sap.ui.webc.main.TreeItemCustom
 * @public
 * @since 1.0.0-rc.8
 */
declare class Tree extends UI5Element {
    /**
     * Defines the mode of the component. Since the tree uses a <code>ui5-list</code> to display its structure,
     * the tree modes are exactly the same as the list modes, and are all applicable.
     *
     * @public
     * @type {sap.ui.webc.main.types.ListMode}
     * @name sap.ui.webc.main.Tree.prototype.mode
     * @defaultValue "None"
     */
    mode: `${ListMode}`;
    /**
     * Defines the text that is displayed when the component contains no items.
     *
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.noDataText
     * @defaultvalue ""
     * @public
     */
    noDataText: string;
    /**
     * Defines the component header text.
     * <br><br>
     * <b>Note:</b> If the <code>header</code> slot is set, this property is ignored.
     *
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.headerText
     * @defaultvalue ""
     * @public
     */
    headerText: string;
    /**
     * Defines the component footer text.
     *
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.footerText
     * @defaultvalue ""
     * @public
     */
    footerText: string;
    /**
     * Defines the accessible name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     * @since 1.8.0
     */
    accessibleName: string;
    /**
     * Defines the IDs of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.8.0
     */
    accessibleNameRef: string;
    /**
     * Defines the description for the accessible role of the component.
     * @protected
     * @type {string}
     * @name sap.ui.webc.main.Tree.prototype.accessibleRoleDescription
     * @defaultvalue undefined
     * @since 1.10.0
     */
    accessibleRoleDescription?: string;
    /**
     * Shows the toggle button at the end, rather than at the beginning of the items
     *
     * @protected
     * @since 1.0.0-rc.8
     */
    _toggleButtonEnd: boolean;
    /**
     * Represents the tree in a very minimal state - icons only with no text and no toggle buttons
     *
     * @protected
     * @since 1.0.0-rc.8
     */
    _minimal: boolean;
    /**
     * Defines the items of the component. Tree items may have other tree items as children.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-tree-item</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITreeItem[]}
     * @name sap.ui.webc.main.Tree.prototype.default
     * @slot items
     * @public
     */
    items: Array<TreeItemBase>;
    /**
     * Defines the component header.
     * <br><br>
     * <b>Note:</b> When the <code>header</code> slot is set, the
     * <code>headerText</code> property is ignored.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Tree.prototype.header
     * @slot header
     * @public
     */
    header: Array<HTMLElement>;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    get list(): TreeList;
    get _role(): "menubar" | "tree";
    get _label(): string | undefined;
    get _hasHeader(): boolean;
    _onListItemStepIn(e: CustomEvent<TreeItemBaseStepInEventDetail>): void;
    _onListItemStepOut(e: CustomEvent<TreeItemBaseStepOutEventDetail>): void;
    _onListItemToggle(e: CustomEvent<TreeItemBaseToggleEventDetail>): void;
    _onListItemClick(e: CustomEvent<ListItemClickEventDetail>): void;
    _onListItemDelete(e: CustomEvent<ListItemDeleteEventDetail>): void;
    _onListItemMouseOver(e: MouseEvent): void;
    _onListItemMouseOut(e: MouseEvent): void;
    _onListSelectionChange(e: CustomEvent<ListSelectionChangeEventDetail>): void;
    _prepareTreeItems(): void;
    /**
     * Returns the corresponding list item for a given tree item
     *
     * @param item The tree item
     * @protected
     */
    _getListItemForTreeItem(item: TreeItemBase): TreeItemBase | undefined;
    /**
     * Returns the a flat array of all tree items
     * @protected
     * @returns {Array}
     */
    getItems(): Array<TreeItemBase>;
    /**
     * Focus a tree item by its index in the flat array of all tree items
     * @protected
     * @param index
     */
    focusItemByIndex(index: number): void;
    /**
     * Perform Depth-First-Search walk on the tree and run a callback on each node
     *
     * @public
     * @param {function} callback function to execute on each node of the tree with 3 arguments: the node, the level and the index
     */
    walk(callback: WalkCallback): void;
    _isInstanceOfTreeItemBase(object: any): object is TreeItemBase;
}
export default Tree;
export type { TreeItemToggleEventDetail, TreeItemMouseoverEventDetail, TreeItemMouseoutEventDetail, TreeItemClickEventDetail, TreeItemDeleteEventDetail, TreeSelectionChangeEventDetail, };
