import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import "@ui5/webcomponents-icons/dist/navigation-up-arrow.js";
import "@ui5/webcomponents-icons/dist/navigation-down-arrow.js";
import ScrollEnablement from "@ui5/webcomponents-base/dist/delegate/ScrollEnablement.js";
type WheelSliderSelectEventDetail = {
    value: string;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <h3>Usage</h3>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/WheelSlider.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.WheelSlider
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-wheelslider
 * @public
 * @since 1.0.0-rc.6
 */
declare class WheelSlider extends UI5Element {
    /**
     * Defines whether the component is disabled
     * (default is set to <code>false</code>).
     * A disabled component can't be pressed or
     * focused, and it is not in the tab chain.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.WheelSlider.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines the currently selected value
     * @type {string}
     * @name sap.ui.webc.main.WheelSlider.prototype.value
     * @defaultvalue ""
     * @public
     */
    value: string;
    /**
     * Defines the label of the wheelslider.
     * @type {string}
     * @name sap.ui.webc.main.WheelSlider.prototype.label
     * @defaultvalue ""
     * @public
     */
    label: string;
    /**
     * Indicates if the wheelslider is expanded.
     * @type {boolean}
     * @name sap.ui.webc.main.WheelSlider.prototype.expanded
     * @defaultvalue false
     * @public
     */
    expanded: boolean;
    /**
     * Indicates if the wheelslider has a cyclic behaviour.
     * @type {boolean}
     * @name sap.ui.webc.main.WheelSlider.prototype.cyclic
     * @defaultvalue false
     * @public
     */
    cyclic: boolean;
    _items: Array<string>;
    _itemsToShow: Array<{
        value: string;
        selected: boolean;
    }>;
    _currentElementIndex: number;
    _scroller: ScrollEnablement;
    _prevWheelTimestamp?: number;
    constructor();
    onBeforeRendering(): void;
    onAfterRendering(): true | undefined;
    get classes(): {
        root: {
            "ui5-wheelslider-root": boolean;
            "ui5-phone": boolean;
        };
    };
    expandSlider(): void;
    collapseSlider(): void;
    get _itemCellHeight(): number;
    _updateScrolling(): void;
    _handleScrollTouchEnd(): void;
    _selectElement(element: HTMLElement): void;
    _getCurrentRepetition(): number;
    _selectElementByIndex(currentIndex: number): void;
    _timesMultipliedOnCyclic(): number;
    _buildItemsToShow(): void;
    _handleArrayBorderReached(currentIndex: number): number;
    /**
     *
     * @param {event} e Wheel Event
     * @private
     *
     * The listener for this event can't be passive as it calls preventDefault()
     */
    _handleWheel(e: WheelEvent): void;
    _onclick(e: MouseEvent): void;
    _onArrowDown(e: KeyboardEvent): void;
    _onArrowUp(e: KeyboardEvent): void;
    _itemDown(): void;
    _itemUp(): void;
    _onkeydown(e: KeyboardEvent): void;
    _selectLimitCell(e: KeyboardEvent, isMax: boolean): void;
}
export default WheelSlider;
export type { WheelSliderSelectEventDetail };
