/**
 * Popup accessible roles.
 *
 * @readonly
 * @enum {string}
 * @public
 * @author SAP SE
 * @alias sap.ui.webc.main.types.PopupAccessibleRole
 */
var PopupAccessibleRole;
(function (PopupAccessibleRole) {
    /**
     * Represents no ARIA role.
     * @public
     * @type {None}
     */
    PopupAccessibleRole["None"] = "None";
    /**
     * Represents the ARIA role "dialog".
     * @public
     * @type {Dialog}
     */
    PopupAccessibleRole["Dialog"] = "Dialog";
    /**
     * Represents the ARIA role "alertdialog".
     * @public
     * @type {AlertDialog}
     */
    PopupAccessibleRole["AlertDialog"] = "AlertDialog";
})(PopupAccessibleRole || (PopupAccessibleRole = {}));
export default PopupAccessibleRole;
//# sourceMappingURL=PopupAccessibleRole.js.map