/**
 * Different types of Priority.
 *
 * @enum {string}
 * @readonly
 * @public
 * @author SAP SE
 * @alias sap.ui.webc.main.types.Priority
 */
var Priority;
(function (Priority) {
    /**
     * High priority.
     * @public
     * @type {High}
     */
    Priority["High"] = "High";
    /**
     * Medium priority.
     * @public
     * @type {Medium}
     */
    Priority["Medium"] = "Medium";
    /**
     * Low priority.
     * @public
     * @type {Low}
     */
    Priority["Low"] = "Low";
    /**
     * Default, none priority.
     * @public
     * @type {None}
     */
    Priority["None"] = "None";
})(Priority || (Priority = {}));
export default Priority;
//# sourceMappingURL=Priority.js.map