var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var Badge_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import { getI18nBundle } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import willShowContent from "@ui5/webcomponents-base/dist/util/willShowContent.js";
// Template
import BadgeTemplate from "./generated/templates/BadgeTemplate.lit.js";
import { BADGE_DESCRIPTION } from "./generated/i18n/i18n-defaults.js";
// Styles
import badgeCss from "./generated/themes/Badge.css.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-badge</code> is a small non-interactive component which contains text information and color chosen from a list of predefined color schemes.
 * It serves the purpose to attract the user attention to some piece of information (state, quantity, condition, etc.).
 *
 * <h3>Usage Guidelines</h3>
 * <ul>
 * <li>If the text is longer than the width of the component, it doesn’t wrap, it shows ellipsis.</li>
 * <li>When truncated, the full text is not visible, therefore, it’s recommended to make more space for longer texts to be fully displayed.</li>
 * <li>Colors are not semantic and have no visual representation in High Contrast Black (sap_belize_hcb) theme.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Badge";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Badge
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-badge
 * @since 0.12.0
 * @public
 */
let Badge = Badge_1 = class Badge extends UI5Element {
    static async onDefine() {
        Badge_1.i18nBundle = await getI18nBundle("@ui5/webcomponents");
    }
    onBeforeRendering() {
        this._hasIcon = this.hasIcon;
        this._iconOnly = this.iconOnly;
    }
    get hasText() {
        return willShowContent(this.text);
    }
    get hasIcon() {
        return !!this.icon.length;
    }
    get iconOnly() {
        return this.hasIcon && !this.hasText;
    }
    get badgeDescription() {
        return Badge_1.i18nBundle.getText(BADGE_DESCRIPTION);
    }
};
__decorate([
    property({ defaultValue: "1" })
], Badge.prototype, "colorScheme", void 0);
__decorate([
    property({ type: Boolean })
], Badge.prototype, "_hasIcon", void 0);
__decorate([
    property({ type: Boolean })
], Badge.prototype, "_iconOnly", void 0);
__decorate([
    slot({ type: Node, "default": true })
], Badge.prototype, "text", void 0);
__decorate([
    slot()
], Badge.prototype, "icon", void 0);
Badge = Badge_1 = __decorate([
    customElement({
        tag: "ui5-badge",
        languageAware: true,
        renderer: litRender,
        template: BadgeTemplate,
        styles: badgeCss,
    })
], Badge);
Badge.define();
export default Badge;
//# sourceMappingURL=Badge.js.map