import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import "@ui5/webcomponents-icons/dist/accept.js";
import WrappingType from "./types/WrappingType.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * Allows the user to set a binary value, such as true/false or yes/no for an item.
 * <br><br>
 * The <code>ui5-checkbox</code> component consists of a box and a label that describes its purpose.
 * If it's checked, an indicator is displayed inside the box.
 * To check/uncheck the <code>ui5-checkbox</code>, the user has to click or tap the square
 * box or its label.
 * <br><br>
 * The <code>ui5-checkbox</code> component only has 2 states - checked and unchecked.
 * Clicking or tapping toggles the <code>ui5-checkbox</code> between checked and unchecked state.
 *
 * <h3>Usage</h3>
 *
 * You can define the checkbox text with via the <code>text</code> property. If the text exceeds the available width, it is truncated by default.
 * In case you prefer text to wrap, set the <code>wrappingType</code> property to "Normal".
 * The touchable area for toggling the <code>ui5-checkbox</code> ends where the text ends.
 * <br><br>
 * You can disable the <code>ui5-checkbox</code> by setting the <code>disabled</code> property to
 * <code>true</code>,
 * or use the <code>ui5-checkbox</code> in read-only mode by setting the <code>readonly</code>
 * property to <code>true</code>.
 *
 * <br><br>
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-checkbox</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>root - Used to style the outermost wrapper of the <code>ui5-checkbox</code></li>
 * <li>label - Used to style the label of the <code>ui5-checkbox</code></li>
 * </ul>
 *
 * <br><br>
 * <h3>Keyboard Handling</h3>
 *
 * The user can use the following keyboard shortcuts to toggle the checked state of the <code>ui5-checkbox</code>.
 * <ul>
 * <li>[SPACE, ENTER] - Toggles between different states: checked, not checked.</li>
 * </ul>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/CheckBox";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.CheckBox
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-checkbox
 * @public
 */
declare class CheckBox extends UI5Element implements IFormElement {
    /**
     * Receives id(or many ids) of the elements that label the component
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.CheckBox.prototype.accessibleNameRef
     * @public
     * @since 1.1.0
     */
    accessibleNameRef: string;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @public
     * @name sap.ui.webc.main.CheckBox.prototype.accessibleName
     * @defaultvalue ""
     * @since 1.1.0
     */
    accessibleName: string;
    /**
     * Defines whether the component is disabled.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.CheckBox.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.CheckBox.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is required.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.CheckBox.prototype.required
     * @defaultvalue false
     * @public
     * @since 1.3.0
     */
    required: boolean;
    /**
    * Defines whether the component is displayed as partially checked.
    * <br><br>
    * <b>Note:</b> The indeterminate state can be set only programmatically and can’t be achieved by user
    * interaction and the resulting visual state depends on the values of the <code>indeterminate</code>
    * and <code>checked</code> properties:
    * <ul>
    * <li> If the component is checked and indeterminate, it will be displayed as partially checked
    * <li> If the component is checked and it is not indeterminate, it will be displayed as checked
    * <li> If the component is not checked, it will be displayed as not checked regardless value of the indeterminate attribute
    * </ul>
    *
    * @type {boolean}
    * @name sap.ui.webc.main.CheckBox.prototype.indeterminate
    * @defaultvalue false
    * @public
    * @since 1.0.0-rc.15
    */
    indeterminate: boolean;
    /**
     * Defines if the component is checked.
     * <br><br>
     * <b>Note:</b> The property can be changed with user interaction,
     * either by cliking/tapping on the component, or by
     * pressing the Enter or Space key.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.CheckBox.prototype.checked
     * @defaultvalue false
     * @formEvents change
     * @formProperty
     * @public
     */
    checked: boolean;
    /**
     * Defines the text of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.CheckBox.prototype.text
     * @defaultvalue ""
     * @public
     */
    text: string;
    /**
     * Defines the value state of the component.
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.CheckBox.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component text wraps when there is not enough space.
     * <br><b>Note:</b> for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * @type {sap.ui.webc.main.types.WrappingType}
     * @name sap.ui.webc.main.CheckBox.prototype.wrappingType
     * @defaultvalue "None"
     * @public
     */
    wrappingType: `${WrappingType}`;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @name sap.ui.webc.main.CheckBox.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines the active state (pressed or not) of the component.
     * @private
     */
    active: boolean;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    _deactivate: () => void;
    constructor();
    onBeforeRendering(): void;
    _enableFormSupport(): void;
    _onclick(): void;
    _onmousedown(): void;
    _onmouseup(): void;
    _onfocusout(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    toggle(): this;
    canToggle(): boolean;
    valueStateTextMappings(): {
        Error: string;
        Warning: string;
        Success: string;
    };
    get ariaLabelText(): string | undefined;
    get classes(): {
        main: {
            "ui5-checkbox--hoverable": boolean;
        };
    };
    get ariaReadonly(): "true" | undefined;
    get effectiveAriaDisabled(): "true" | undefined;
    get effectiveAriaChecked(): boolean | "mixed";
    get ariaLabelledBy(): string | undefined;
    get ariaDescribedBy(): string | undefined;
    get hasValueState(): boolean;
    get valueStateText(): string | undefined;
    get effectiveTabIndex(): string | undefined;
    get isCompletelyChecked(): boolean;
    static onDefine(): Promise<void>;
}
export default CheckBox;
