import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ListItemBase from "./ListItemBase.js";
/**
 * @class
 * The <code>ui5-li-groupheader</code> is a special list item, used only to separate other list items into logical groups.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.GroupHeaderListItem
 * @extends sap.ui.webc.main.ListItemBase
 * @tagname ui5-li-groupheader
 * @implements sap.ui.webc.main.IListItem
 * @public
 */
declare class GroupHeaderListItem extends ListItemBase {
    /**
     * Defines the text alternative of the component.
     * Note: If not provided a default text alternative will be set, if present.
     *
     * @type {string}
     * @name sap.ui.webc.main.GroupHeaderListItem.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Defines the text of the component.
     * <br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.GroupHeaderListItem.prototype.default
     * @slot
     * @public
     */
    static i18nBundle: I18nBundle;
    get groupItem(): boolean;
    get groupHeaderText(): string;
    get ariaLabelText(): string;
    static onDefine(): Promise<void>;
}
export default GroupHeaderListItem;
