import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/not-editable.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/information.js";
import type SuggestionItem from "./SuggestionItem.js";
import type { InputSuggestion, SuggestionComponent } from "./features/InputSuggestions.js";
import type InputSuggestions from "./features/InputSuggestions.js";
import type FormSupportT from "./features/InputElementsFormSupport.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
import type SuggestionListItem from "./SuggestionListItem.js";
import type { PopupScrollEventDetail } from "./Popup.js";
import InputType from "./types/InputType.js";
import Popover from "./Popover.js";
import Icon from "./Icon.js";
type NativeInputAttributes = {
    min?: number;
    max?: number;
    step?: number;
};
type AccInfo = {
    ariaRoledescription?: string;
    ariaDescribedBy?: string;
    ariaHasPopup?: string;
    ariaAutoComplete?: string;
    role?: string;
    ariaControls?: string;
    ariaExpanded?: string;
    ariaDescription?: string;
    ariaLabel?: string;
};
declare enum INPUT_ACTIONS {
    ACTION_ENTER = "enter",
    ACTION_USER_INPUT = "input"
}
type InputEventDetail = {
    inputType?: string;
};
type InputSuggestionItemSelectEventDetail = {
    item: SuggestionItem;
};
type InputSuggestionItemPreviewEventDetail = {
    item: SuggestionItem;
    targetRef: SuggestionListItem;
};
type InputSuggestionScrollEventDetail = {
    scrollTop: number;
    scrollContainer: HTMLElement;
};
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-input</code> component allows the user to enter and edit text or numeric values in one line.
 * <br>
 * Additionally, you can provide <code>suggestionItems</code>,
 * that are displayed in a popover right under the input.
 * <br><br>
 * The text field can be editable or read-only (<code>readonly</code> property),
 * and it can be enabled or disabled (<code>disabled</code> property).
 * To visualize semantic states, such as "error" or "warning", the <code>valueState</code> property is provided.
 * When the user makes changes to the text, the change event is fired,
 * which enables you to react on any text change.
 * <br><br>
 * <b>Note:</b> If you are using the <code>ui5-input</code> as a single npm module,
 * don't forget to import the <code>InputSuggestions</code> module from
 * "@ui5/webcomponents/dist/features/InputSuggestions.js"
 * to enable the suggestions functionality.
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-input</code> provides the following keyboard shortcuts:
 * <br>
 *
 * <ul>
 * <li>[ESC] - Closes the suggestion list, if open. If closed or not enabled, cancels changes and reverts to the value which the Input field had when it got the focus.</li>
 * <li>[ENTER] or [RETURN] - If suggestion list is open takes over the current matching item and closes it. If value state or group header is focused, does nothing.</li>
 * <li>[DOWN] - Focuses the next matching item in the suggestion list.</li>
 * <li>[UP] - Focuses the previous matching item in the suggestion list.</li>
 * <li>[HOME] - If focus is in the text input, moves caret before the first character. If focus is in the list, highlights the first item and updates the input accordingly.</li>
 * <li>[END] - If focus is in the text input, moves caret after the last character. If focus is in the list, highlights the last item and updates the input accordingly.</li>
 * <li>[PAGEUP] - If focus is in the list, moves highlight up by page size (10 items by default). If focus is in the input, does nothing.</li>
 * <li>[PAGEDOWN] - If focus is in the list, moves highlight down by page size (10 items by default). If focus is in the input, does nothing.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Input.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/features/InputSuggestions.js";</code> (optional - for input suggestions support)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Input
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-input
 * @appenddocs sap.ui.webc.main.SuggestionItem sap.ui.webc.main.SuggestionGroupItem
 * @implements sap.ui.webc.main.IInput
 * @public
 */
declare class Input extends UI5Element implements SuggestionComponent, IFormElement {
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines if characters within the suggestions are to be highlighted
     * in case the input value matches parts of the suggestions text.
     * <br><br>
     * <b>Note:</b> takes effect when <code>showSuggestions</code> is set to <code>true</code>
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     * @since 1.0.0-rc.8
     */
    highlight: boolean;
    /**
     * Defines a short hint intended to aid the user with data entry when the
     * component has no value.
     * @type {string}
     * @name sap.ui.webc.main.Input.prototype.placeholder
     * @defaultvalue ""
     * @public
     */
    placeholder: string;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is required.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.required
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.3
     */
    required: boolean;
    /**
     * Defines whether the value will be autcompleted to match an item
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.noTypeahead
     * @defaultvalue false
     * @public
     * @since 1.4.0
     */
    noTypeahead: boolean;
    /**
     * Defines the HTML type of the component.
     * <br><br>
     * <b>Notes:</b>
     * <ul>
     * <li>The particular effect of this property differs depending on the browser
     * and the current language settings, especially for type <code>Number</code>.</li>
     * <li>The property is mostly intended to be used with touch devices
     * that use different soft keyboard layouts depending on the given input type.</li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.InputType}
     * @name sap.ui.webc.main.Input.prototype.type
     * @defaultvalue "Text"
     * @public
     */
    type: `${InputType}`;
    /**
     * Defines the value of the component.
     * <br><br>
     * <b>Note:</b> The property is updated upon typing.
     *
     * @type {string}
     * @name sap.ui.webc.main.Input.prototype.value
     * @defaultvalue ""
     * @formEvents change input
     * @formProperty
     * @public
     */
    value: string;
    /**
     * Defines the inner stored value of the component.
     * <br><br>
     * <b>Note:</b> The property is updated upon typing. In some special cases the old value is kept (e.g. deleting the value after the dot in a float)
     *
     * @type {string}
     * @defaultvalue ""
     * @private
     */
    _innerValue: string;
    /**
     * Defines the value state of the component.
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.Input.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @name sap.ui.webc.main.Input.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines whether the component should show suggestions, if such are present.
     * <br><br>
     * <b>Note:</b> You need to import the <code>InputSuggestions</code> module
     * from <code>"@ui5/webcomponents/dist/features/InputSuggestions.js"</code> to enable this functionality.
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.showSuggestions
     * @defaultvalue false
     * @public
     */
    showSuggestions: boolean;
    /**
     * Sets the maximum number of characters available in the input field.
     * <br><br>
     * <b>Note:</b> This property is not compatible with the ui5-input type InputType.Number. If the ui5-input type is set to Number, the maxlength value is ignored.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Input.prototype.maxlength
     * @since 1.0.0-rc.5
     * @public
     */
    maxlength?: number;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Input.prototype.accessibleName
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the input.
     *
     * @type {string}
     * @name sap.ui.webc.main.Input.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    /**
     * Defines whether the clear icon of the input will be shown.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Input.prototype.showClearIcon
     * @defaultvalue false
     * @public
     * @since 1.2.0
     */
    showClearIcon: boolean;
    /**
     * Defines whether the clear icon is visible.
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     * @since 1.2.0
     */
    effectiveShowClearIcon: boolean;
    /**
     * @private
     */
    focused: boolean;
    openOnMobile: boolean;
    open: boolean;
    /**
     * Determines whether to manually show the suggestions popover
     * @private
     */
    _forceOpen: boolean;
    /**
     * Indicates whether the visual focus is on the value state header
     * @private
     */
    _isValueStateFocused: boolean;
    _inputAccInfo: AccInfo;
    _nativeInputAttributes: NativeInputAttributes;
    _inputWidth?: number;
    _listWidth?: number;
    _isPopoverOpen: boolean;
    _inputIconFocused: boolean;
    /**
     * Constantly updated value of texts collected from the associated labels
     * @private
     */
    _associatedLabelsTexts?: string;
    /**
     * Constantly updated value of texts collected from the accessibleNameRef elements
     * @private
     */
    _accessibleLabelsRefTexts?: string;
    /**
     * Defines the suggestion items.
     * <br><br>
     * Example:
     * <br><br>
     * &lt;ui5-input show-suggestions><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;&lt;ui5-suggestion-item text="Item #1">&lt;/ui5-suggestion-item><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;&lt;ui5-suggestion-item text="Item #2">&lt;/ui5-suggestion-item><br>
     * &lt;/ui5-input>
     * <br>
     * <ui5-input show-suggestions>
     * <ui5-suggestion-group-item text="Group #1"></ui5-suggestion-group-item>
     * <ui5-suggestion-item text="Item #1"></ui5-suggestion-item>
     * <ui5-suggestion-item text="Item #2"></ui5-suggestion-item>
     * <ui5-suggestion-group-item text="Group #2"></ui5-suggestion-group-item>
     * <ui5-suggestion-item text="Item #3"></ui5-suggestion-item>
     * <ui5-suggestion-item text="Item #4"></ui5-suggestion-item>
     * </ui5-input>
     * <br><br>
     * <b>Note:</b> The suggestions would be displayed only if the <code>showSuggestions</code>
     * property is set to <code>true</code>.
     * <br><br>
     * <b>Note:</b> The <code>&lt;ui5-suggestion-item&gt;</code> and <code>&lt;ui5-suggestion-group-item&gt;</code> are recommended to be used as suggestion items.
     * <br><br>
     * <b>Note:</b> Importing the Input Suggestions Support feature:
     * <br>
     * <code>import "@ui5/webcomponents/dist/features/InputSuggestions.js";</code>
     * <br>
     * automatically imports the <code>&lt;ui5-suggestion-item></code> and <code>&lt;ui5-suggestion-group-item></code> for your convenience.
     *
     * @type {sap.ui.webc.main.IInputSuggestionItem[]}
     * @name sap.ui.webc.main.Input.prototype.default
     * @slot suggestionItems
     * @public
     */
    suggestionItems: Array<SuggestionItem>;
    /**
     * Defines the icon to be displayed in the component.
     *
     * @type {sap.ui.webc.main.IIcon[]}
     * @name sap.ui.webc.main.Input.prototype.icon
     * @slot
     * @public
     */
    icon: Array<Icon>;
    /**
     * The slot is used for native <code>input</code> HTML element to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @private
     */
    formSupport: Array<HTMLElement>;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br><br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * <br><br>
     * <b>Note:</b> If the component has <code>suggestionItems</code>,
     * the <code>valueStateMessage</code> would be displayed as part of the same popover, if used on desktop, or dialog - on phone.
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Input.prototype.valueStateMessage
     * @since 1.0.0-rc.6
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    hasSuggestionItemSelected: boolean;
    valueBeforeItemSelection: string;
    valueBeforeItemPreview: string;
    suggestionSelectionCancelled: boolean;
    previousValue: string;
    firstRendering: boolean;
    typedInValue: string;
    lastConfirmedValue: string;
    isTyping: boolean;
    suggestionObjects: Array<InputSuggestion>;
    _handleResizeBound: ResizeObserverCallback;
    _keepInnerValue: boolean;
    _shouldAutocomplete?: boolean;
    _keyDown?: boolean;
    _isKeyNavigation?: boolean;
    Suggestions?: InputSuggestions;
    FormSupport?: typeof FormSupportT;
    _selectedText?: string;
    _clearIconClicked?: boolean;
    _focusedAfterClear: boolean;
    _performTextSelection?: boolean;
    _previewItem?: SuggestionListItem;
    static i18nBundle: I18nBundle;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    onBeforeRendering(): void;
    onAfterRendering(): Promise<void>;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _handleUp(e: KeyboardEvent): void;
    _handleDown(e: KeyboardEvent): void;
    _handleSpace(e: KeyboardEvent): void;
    _handleTab(): void;
    _handleEnter(e: KeyboardEvent): void;
    _handlePageUp(e: KeyboardEvent): void;
    _handlePageDown(e: KeyboardEvent): void;
    _handleHome(e: KeyboardEvent): void;
    _handleEnd(e: KeyboardEvent): void;
    _handleEscape(): void;
    _onfocusin(e: FocusEvent): Promise<void>;
    /**
     * Called on "focusin" of the native input HTML Element.
     * <b>Note:</b> implemented in MultiInput, but used in the Input template.
     */
    innerFocusIn(): void | undefined;
    _onfocusout(e: FocusEvent): void;
    _clearPopoverFocusAndSelection(): void;
    _click(): void;
    _handleChange(): void;
    _clear(): void;
    _iconMouseDown(): void;
    _scroll(e: CustomEvent<PopupScrollEventDetail>): void;
    _handleInput(e: InputEvent | CustomEvent<InputEventDetail>): void;
    _startsWithMatchingItems(str: string): Array<SuggestionItem>;
    _getFirstMatchingItem(current: string): SuggestionItem | undefined;
    _handleTypeAhead(item: SuggestionItem): void;
    _handleResize(): void;
    _updateAssociatedLabelsTexts(): void;
    _closeRespPopover(): void;
    _afterOpenPopover(): Promise<void>;
    _afterClosePopover(): void;
    /**
     * Checks if the value state popover is open.
     * @returns {boolean} true if the value state popover is open, false otherwise
     */
    isValueStateOpened(): boolean;
    openPopover(): Promise<void>;
    closePopover(): Promise<void>;
    _getPopover(): Promise<Popover>;
    /**
     * Manually opens the suggestions popover, assuming suggestions are enabled. Items must be preloaded for it to open.
     * @public
     * @method
     * @name sap.ui.webc.main.Input#openPicker
     * @return {void}
     * @since 1.3.0
     */
    openPicker(): void;
    enableSuggestions(): void;
    selectSuggestion(item: SuggestionItem, keyboardUsed: boolean): void;
    previewSuggestion(item: SuggestionListItem): void;
    /**
     * Updates the input value on item preview.
     * @param {Object} item The item that is on preview
     */
    updateValueOnPreview(item: SuggestionListItem): void;
    /**
     * The suggestion item on preview.
     * @type {sap.ui.webc.main.IInputSuggestionItem | null}
     * @name sap.ui.webc.main.Input.prototype.previewItem
     * @readonly
     * @public
     */
    get previewItem(): SuggestionItem | null;
    fireEventByAction(action: INPUT_ACTIONS, e: InputEvent): Promise<void>;
    getInputValue(): Promise<string>;
    getInputDOMRef(): Promise<HTMLInputElement | Input | null>;
    getInputDOMRefSync(): HTMLInputElement | null;
    /**
     * Returns a reference to the native input element
     * @protected
     */
    get nativeInput(): HTMLInputElement | null;
    get nativeInputWidth(): number;
    getLabelableElementId(): string;
    getSuggestionByListItem(item: SuggestionListItem): SuggestionItem;
    /**
     * Returns if the suggestions popover is scrollable.
     * The method returns <code>Promise</code> that resolves to true,
     * if the popup is scrollable and false otherwise.
     * @returns {Promise}
     */
    isSuggestionsScrollable(): Promise<boolean>;
    getInputId(): string;
    onItemMouseOver(e: MouseEvent): void;
    onItemMouseOut(e: MouseEvent): void;
    onItemMouseDown(e: MouseEvent): void;
    onItemSelected(item: SuggestionItem, keyboardUsed: boolean): void;
    onItemPreviewed(item: SuggestionListItem): void;
    get valueStateTypeMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
    valueStateTextMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
    announceSelectedItem(): void;
    get _readonly(): boolean;
    get _headerTitleText(): string;
    get clearIconAccessibleName(): string;
    get inputType(): string;
    get isTypeNumber(): boolean;
    get suggestionsTextId(): string;
    get valueStateTextId(): string;
    get accInfo(): {
        input: {
            ariaRoledescription: string | undefined;
            ariaDescribedBy: string | undefined;
            ariaInvalid: string | undefined;
            ariaHasPopup: string | undefined;
            ariaAutoComplete: string | undefined;
            role: string | undefined;
            ariaControls: string | undefined;
            ariaExpanded: string | undefined;
            ariaDescription: string | undefined;
            ariaLabel: string | undefined;
        };
    };
    get nativeInputAttributes(): {
        min: number | undefined;
        max: number | undefined;
        step: string | number | undefined;
    };
    get ariaValueStateHiddenText(): string | undefined;
    get itemSelectionAnnounce(): string;
    get iconsCount(): number;
    get classes(): ClassMap;
    get styles(): {
        popoverHeader: {
            "max-width": string;
        };
        suggestionPopoverHeader: {
            display: string;
            width: string;
        };
        suggestionsPopover: {
            "min-width": string;
            "max-width": string;
        };
        innerInput: {
            padding: string;
        };
    };
    get suggestionSeparators(): string;
    get valueStateMessageText(): Node[];
    get shouldDisplayOnlyValueStateMessage(): boolean;
    get shouldDisplayDefaultValueStateMessage(): boolean;
    get hasValueState(): boolean;
    get hasValueStateMessage(): boolean;
    get valueStateText(): string | undefined;
    get suggestionsText(): string;
    get availableSuggestionsCount(): string | undefined;
    get step(): "any" | undefined;
    get _isPhone(): boolean;
    get _isSuggestionsFocused(): boolean | undefined;
    /**
     * Returns the placeholder value.
     * @protected
     */
    get _placeholder(): string;
    /**
     * This method is relevant for sap_horizon theme only
     */
    get _valueStateInputIcon(): string;
    get _valueStatePopoverHorizontalAlign(): "Left" | "Right";
    /**
     * This method is relevant for sap_horizon theme only
     */
    get _valueStateMessageInputIcon(): string;
    /**
     * Returns the caret position inside the native input
     * @protected
     */
    getCaretPosition(): number | null;
    /**
     * Sets the caret to a certain position inside the native input
     * @protected
     * @param pos
     */
    setCaretPosition(pos: number | null): void;
    /**
     * Removes the fractional part of floating-point number.
     * @param {string} value the numeric value of Input of type "Number"
     */
    removeFractionalPart(value: string): string;
    static onDefine(): Promise<void>;
}
export default Input;
export type { InputSuggestionScrollEventDetail, InputSuggestionItemSelectEventDetail, InputSuggestionItemPreviewEventDetail, };
