import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { I18nText } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import LinkDesign from "./types/LinkDesign.js";
import WrappingType from "./types/WrappingType.js";
type LinkClickEventDetail = {
    altKey: boolean;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-link</code> is a hyperlink component that is used to navigate to other
 * apps and web pages, or to trigger actions.
 * It is a clickable text element, visualized in such a way that it stands out
 * from the standard text.
 * On hover, it changes its style to an underlined text to provide additional feedback to the user.
 *
 *
 * <h3>Usage</h3>
 *
 * You can set the <code>ui5-link</code> to be enabled or disabled.
 * <br><br>
 * To create a visual hierarchy in large lists of links, you can set the less important links as
 * <code>Subtle</code> or the more important ones as <code>Emphasized</code>,
 * by using the <code>design</code> property.
 * <br><br>
 * If the <code>href</code> property is set, the link behaves as the HTML
 * anchor tag (<code>&lt;a&gt;&lt;a&#47;&gt;</code>) and opens the specified URL in the given target frame (<code>target</code> property).
 * To specify where the linked content is opened, you can use the <code>target</code> property.
 *
 * <h3>Responsive behavior</h3>
 *
 * If there is not enough space, the text of the <code>ui5-link</code> becomes truncated.
 * If the <code>wrappingType</code> property is set to <code>"Normal"</code>, the text is displayed
 * on several lines instead of being truncated.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Link";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Link
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-link
 * @public
 */
declare class Link extends UI5Element implements ITabbable {
    /**
     * Defines whether the component is disabled.
     * <br><br>
     * <b>Note:</b> When disabled, the click event cannot be triggered by the user.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Link.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines the tooltip of the component.
     * @type {string}
     * @defaultvalue ""
     * @private
     * @name sap.ui.webc.main.Link.prototype.title
     * @since 1.18.0
     */
    title: string;
    /**
     * Defines the component href.
     * <br><br>
     * <b>Note:</b> Standard hyperlink behavior is supported.
     *
     * @type {string}
     * @name sap.ui.webc.main.Link.prototype.href
     * @defaultvalue ""
     * @public
     */
    href: string;
    /**
     * Defines the component target.
     * <br><br>
     * <b>Notes:</b>
     *
     * <ul>
     * <li><code>_self</code></li>
     * <li><code>_top</code></li>
     * <li><code>_blank</code></li>
     * <li><code>_parent</code></li>
     * <li><code>_search</code></li>
     * </ul>
     *
     * <b>This property must only be used when the <code>href</code> property is set.</b>
     *
     * @type {string}
     * @name sap.ui.webc.main.Link.prototype.target
     * @defaultvalue ""
     * @public
     */
    target: string;
    /**
     * Defines the component design.
     * <br><br>
     * <b>Note:</b> Avaialble options are <code>Default</code>, <code>Subtle</code>, and <code>Emphasized</code>.
     *
     * @type {sap.ui.webc.main.types.LinkDesign}
     * @name sap.ui.webc.main.Link.prototype.design
     * @defaultvalue "Default"
     * @public
     */
    design: `${LinkDesign}`;
    /**
     * Defines how the text of a component will be displayed when there is not enough space.
     * <br><b>Note:</b> for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * @type {sap.ui.webc.main.types.WrappingType}
     * @name sap.ui.webc.main.Link.prototype.wrappingType
     * @defaultvalue "None"
     * @public
     */
    wrappingType: `${WrappingType}`;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Link.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.2.0
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the input
     *
     * @type {string}
     * @name sap.ui.webc.main.Link.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    /**
     * Defines the ARIA role of the component.
     *
     * <b>Note:</b> Use the "button" role in cases when navigation is not expected to occur and the href property is not defined.
     *
     * @type {string}
     * @name sap.ui.webc.main.Link.prototype.accessibleRole
     * @defaultvalue "link"
     * @public
     * @since 1.9.0
     */
    accessibleRole: string;
    /**
     * An object of strings that defines several additional accessibility attribute values
     * for customization depending on the use case.
     *
     * It supports the following fields:
     *
     * <ul>
     * 		<li><code>expanded</code>: Indicates whether the anchor element, or another grouping element it controls, is currently expanded or collapsed. Accepts the following string values:
     *			<ul>
     *				<li><code>true</code></li>
     *				<li><code>false</code></li>
     *			</ul>
     * 		</li>
     * 		<li><code>hasPopup</code>: Indicates the availability and type of interactive popup element, such as menu or dialog, that can be triggered by the anchor element. Accepts the following string values:
     * 			<ul>
     *				<li><code>Dialog</code></li>
     *				<li><code>Grid</code></li>
     *				<li><code>ListBox</code></li>
     *				<li><code>Menu</code></li>
     *				<li><code>Tree</code></li>
     * 			</ul>
     * 		</li>
     * </ul>
     * @type {object}
     * @name sap.ui.webc.main.Link.prototype.accessibilityAttributes
     * @public
     * @since 1.1.0
     */
    accessibilityAttributes: {
        expanded: "true" | "false";
        hasPopup: "Dialog" | "Grid" | "ListBox" | "Menu" | "Tree";
    };
    _rel: string | undefined;
    _tabIndex: string;
    /**
     * Indicates if the element is on focus.
     * @private
     */
    focused: boolean;
    /**
     * Defines the text of the component.
     * <br><b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.Link.prototype.default
     * @slot
     * @public
     */
    _dummyAnchor: HTMLAnchorElement;
    static i18nBundle: I18nBundle;
    constructor();
    onBeforeRendering(): void;
    _isCrossOrigin(): boolean;
    get effectiveTabIndex(): string;
    get ariaLabelText(): string | undefined;
    get hasLinkType(): boolean;
    static typeTextMappings(): Record<string, I18nText>;
    get linkTypeText(): string;
    get parsedRef(): string | undefined;
    get effectiveAccRole(): string;
    static onDefine(): Promise<void>;
    _onclick(e: MouseEvent | KeyboardEvent): void;
    _onfocusin(e: FocusEvent): void;
    _onfocusout(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
}
export default Link;
export type { LinkClickEventDetail };
