import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ListMode from "./types/ListMode.js";
import ListGrowingMode from "./types/ListGrowingMode.js";
import ListItemBase from "./ListItemBase.js";
import type { SelectionRequestEventDetail, PressEventDetail } from "./ListItem.js";
import ListSeparators from "./types/ListSeparators.js";
type ListItemFocusEventDetail = {
    item: ListItemBase;
};
type ListSelectionChangeEventDetail = {
    selectedItems: Array<ListItemBase>;
    previouslySelectedItems: Array<ListItemBase>;
    selectionComponentPressed: boolean;
    targetItem: ListItemBase;
    key?: string;
};
type ListItemDeleteEventDetail = {
    item: ListItemBase;
};
type ListItemCloseEventDetail = {
    item: ListItemBase;
};
type ListItemToggleEventDetail = {
    item: ListItemBase;
};
type ListItemClickEventDetail = {
    item: ListItemBase;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-list</code> component allows displaying a list of items, advanced keyboard
 * handling support for navigating between items, and predefined modes to improve the development efficiency.
 * <br><br>
 * The <code>ui5-list</code> is a container for the available list items:
 * <ul>
 * <li><code>ui5-li</code></li>
 * <li><code>ui5-li-custom</code></li>
 * <li><code>ui5-li-groupheader</code></li>
 * </ul>
 * <br><br>
 * To benefit from the built-in selection mechanism, you can use the available
 * selection modes, such as
 * <code>SingleSelect</code>, <code>MultiSelect</code> and <code>Delete</code>.
 * <br><br>
 * Additionally, the <code>ui5-list</code> provides header, footer, and customization for the list item separators.
 *
 * <br><br>
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Basic Navigation</h4>
 * The <code>ui5-list</code> provides advanced keyboard handling.
 * When a list is focused the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 *
 * <ul>
 * <li>[UP/DOWN] - Navigates up and down the items</li>
 * <li>[HOME] - Navigates to first item</li>
 * <li>[END] - Navigates to the last item</li>
 * </ul>
 *
 * The user can use the following keyboard shortcuts to perform actions (such as select, delete),
 * when the <code>mode</code> property is in use:
 * <ul>
 * <li>[SPACE] - Select an item (if <code>type</code> is 'Active') when <code>mode</code> is selection</li>
 * <li>[DELETE] - Delete an item if <code>mode</code> property is <code>Delete</code></li>
 * </ul>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/List.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/StandardListItem.js";</code> (for <code>ui5-li</code>)
 * <br>
 * <code>import "@ui5/webcomponents/dist/CustomListItem.js";</code> (for <code>ui5-li-custom</code>)
 * <br>
 * <code>import "@ui5/webcomponents/dist/GroupHeaderListItem.js";</code> (for <code>ui5-li-groupheader</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.List
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-list
 * @appenddocs sap.ui.webc.main.StandardListItem sap.ui.webc.main.CustomListItem sap.ui.webc.main.GroupHeaderListItem
 * @public
 */
declare class List extends UI5Element {
    /**
     * Defines the component header text.
     * <br><br>
     * <b>Note:</b> If <code>header</code> is set this property is ignored.
     *
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.headerText
     * @defaultvalue ""
     * @public
     */
    headerText: string;
    /**
     * Defines the footer text.
     *
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.footerText
     * @defaultvalue ""
     * @public
     */
    footerText: string;
    /**
     * Determines whether the component is indented.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.List.prototype.indent
     * @defaultvalue false
     * @public
     */
    indent: boolean;
    /**
     * Defines the mode of the component.
     *
     * @type {sap.ui.webc.main.types.ListMode}
     * @name sap.ui.webc.main.List.prototype.mode
     * @defaultvalue "None"
     * @public
     */
    mode: `${ListMode}`;
    /**
     * Defines the text that is displayed when the component contains no items.
     *
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.noDataText
     * @defaultvalue ""
     * @public
     */
    noDataText: string;
    /**
     * Defines the item separator style that is used.
     *
     * @type {sap.ui.webc.main.types.ListSeparators}
     * @name sap.ui.webc.main.List.prototype.separators
     * @defaultvalue "All"
     * @public
     */
    separators: `${ListSeparators}`;
    /**
     * Defines whether the component will have growing capability either by pressing a <code>More</code> button,
     * or via user scroll. In both cases <code>load-more</code> event is fired.
     * <br><br>
     * <b>Restrictions:</b> <code>growing="Scroll"</code> is not supported for Internet Explorer,
     * on IE the component will fallback to <code>growing="Button"</code>.
     * @type {sap.ui.webc.main.types.ListGrowingMode}
     * @name sap.ui.webc.main.List.prototype.growing
     * @defaultvalue "None"
     * @since 1.0.0-rc.13
     * @public
     */
    growing: `${ListGrowingMode}`;
    /**
     * Defines if the component would display a loading indicator over the list.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.List.prototype.busy
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.6
     */
    busy: boolean;
    /**
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.List.prototype.busyDelay
     * @defaultValue 1000
     * @public
     */
    busyDelay: number;
    /**
     * Defines the accessible name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Defines the IDs of the elements that label the input.
     *
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    /**
     * Defines the accessible role of the component.
     * <br><br>
     * @public
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.accessibleRole
     * @defaultvalue "list"
     * @since 1.0.0-rc.15
     */
    accessibleRole: string;
    /**
     * Defines the description for the accessible role of the component.
     * @protected
     * @type {string}
     * @name sap.ui.webc.main.List.prototype.accessibleRoleDescription
     * @defaultvalue undefined
     * @since 1.10.0
     */
    accessibleRoleDescription?: string;
    /**
     * Defines if the entire list is in view port.
     * @private
     */
    _inViewport: boolean;
    /**
     * Defines the active state of the <code>More</code> button.
     * @private
     */
    _loadMoreActive: boolean;
    /**
     * Defines the items of the component.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-li</code>, <code>ui5-li-custom</code>, and <code>ui5-li-groupheader</code> for the intended design.
     *
     * @type {sap.ui.webc.main.IListItem[]}
     * @name sap.ui.webc.main.List.prototype.default
     * @slot items
     * @public
     */
    items: Array<ListItemBase>;
    /**
     * Defines the component header.
     * <br><br>
     * <b>Note:</b> When <code>header</code> is set, the
     * <code>headerText</code> property is ignored.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.List.prototype.header
     * @slot
     * @public
     */
    header: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    _previouslyFocusedItem: ListItemBase | null;
    _forwardingFocus: boolean;
    resizeListenerAttached: boolean;
    listEndObserved: boolean;
    _handleResize: ResizeObserverCallback;
    initialIntersection: boolean;
    _selectionRequested?: boolean;
    growingIntersectionObserver?: IntersectionObserver | null;
    _itemNavigation: ItemNavigation;
    _beforeElement?: HTMLElement | null;
    _afterElement?: HTMLElement | null;
    static onDefine(): Promise<void>;
    constructor();
    onExitDOM(): void;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    attachForResize(): void;
    get shouldRenderH1(): string | false;
    get headerID(): string;
    get modeLabelID(): string;
    get listEndDOM(): Element | null;
    get hasData(): boolean;
    get showNoDataText(): string | false;
    get isDelete(): boolean;
    get isSingleSelect(): boolean;
    get isMultiSelect(): boolean;
    get ariaLabelledBy(): string | undefined;
    get ariaLabelTxt(): string | undefined;
    get ariaLabelModeText(): string;
    get grows(): boolean;
    get growsOnScroll(): boolean;
    get growsWithButton(): boolean;
    get _growingButtonText(): string;
    get busyIndPosition(): "absolute" | "sticky";
    get styles(): {
        busyInd: {
            position: string;
        };
    };
    get classes(): ClassMap;
    prepareListItems(): void;
    observeListEnd(): Promise<void>;
    unobserveListEnd(): void;
    onInteresection(entries: Array<IntersectionObserverEntry>): void;
    onSelectionRequested(e: CustomEvent<SelectionRequestEventDetail>): void;
    handleSingleSelect(item: ListItemBase): boolean;
    handleSingleSelectBegin(item: ListItemBase): boolean;
    handleSingleSelectEnd(item: ListItemBase): boolean;
    handleSingleSelectAuto(item: ListItemBase): boolean;
    handleMultiSelect(item: ListItemBase, selected: boolean): boolean;
    handleDelete(item: ListItemBase): boolean;
    deselectSelectedItems(): void;
    getSelectedItems(): Array<ListItemBase>;
    getEnabledItems(): Array<ListItemBase>;
    getItems(): Array<ListItemBase>;
    getItemsForProcessing(): Array<ListItemBase>;
    _revertSelection(previouslySelectedItems: Array<ListItemBase>): void;
    _onkeydown(e: KeyboardEvent): void;
    _onLoadMoreKeydown(e: KeyboardEvent): void;
    _onLoadMoreKeyup(e: KeyboardEvent): void;
    _onLoadMoreMousedown(): void;
    _onLoadMoreMouseup(): void;
    _onLoadMoreClick(): void;
    checkListInViewport(): void;
    loadMore(): void;
    _handleTabNext(e: KeyboardEvent): void;
    _onfocusin(e: FocusEvent): void;
    isForwardElement(element: HTMLElement): boolean;
    isForwardAfterElement(element: HTMLElement): boolean;
    onItemTabIndexChange(e: CustomEvent): void;
    onItemFocused(e: CustomEvent): void;
    onItemPress(e: CustomEvent<PressEventDetail>): void;
    onItemClose(e: CustomEvent<ListItemCloseEventDetail>): void;
    onItemToggle(e: CustomEvent<ListItemToggleEventDetail>): void;
    onForwardBefore(e: CustomEvent): void;
    onForwardAfter(e: CustomEvent): void;
    focusBeforeElement(): void;
    focusAfterElement(): void;
    focusGrowingButton(): void;
    getGrowingButton(): HTMLElement;
    /**
     * Focuses the first list item and sets its tabindex to "0" via the ItemNavigation
     * @protected
     */
    focusFirstItem(): void;
    focusPreviouslyFocusedItem(): void;
    focusFirstSelectedItem(): void;
    /**
     * Focuses a list item and sets its tabindex to "0" via the ItemNavigation
     * @protected
     * @param item
     */
    focusItem(item: ListItemBase): void;
    onFocusRequested(e: CustomEvent): void;
    setForwardingFocus(forwardingFocus: boolean): void;
    getForwardingFocus(): boolean;
    setPreviouslyFocusedItem(item: ListItemBase): void;
    getPreviouslyFocusedItem(): ListItemBase | null;
    getFirstItem(filter: (item: ListItemBase) => boolean): ListItemBase | null;
    getAfterElement(): HTMLElement;
    getBeforeElement(): HTMLElement;
    getIntersectionObserver(): IntersectionObserver;
}
export default List;
export type { ListItemClickEventDetail, ListItemFocusEventDetail, ListItemDeleteEventDetail, ListItemCloseEventDetail, ListItemToggleEventDetail, ListSelectionChangeEventDetail, };
