import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { IMultiComboBoxItem } from "./MultiComboBox.js";
/**
 * @class
 * The <code>ui5-mcb-group-item</code> is type of suggestion item,
 * that can be used to split the <code>ui5-multi-combobox</code> suggestions into groups.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.MultiComboBoxGroupItem
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-mcb-group-item
 * @public
 * @implements sap.ui.webc.main.IMultiComboBoxItem
 * @since 1.4.0
 */
declare class MultiComboBoxGroupItem extends UI5Element implements IMultiComboBoxItem {
    /**
     * Defines the text of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.MultiComboBoxGroupItem.prototype.text
     * @defaultvalue ""
     * @public
     */
    text: string;
    /**
     * Used to avoid tag name checks
     * @protected
     */
    get isGroupItem(): boolean;
    get selected(): boolean;
    get stableDomRef(): string;
}
export default MultiComboBoxGroupItem;
