import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import WrappingType from "./types/WrappingType.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-radio-button</code> component enables users to select a single option from a set of options.
 * When a <code>ui5-radio-button</code> is selected by the user, the
 * <code>change</code> event is fired.
 * When a <code>ui5-radio-button</code> that is within a group is selected, the one
 * that was previously selected gets automatically deselected. You can group radio buttons by using the <code>name</code> property.
 * <br>
 * <b>Note:</b> If <code>ui5-radio-button</code> is not part of a group, it can be selected once, but can not be deselected back.
 *
 * <h3>Keyboard Handling</h3>
 *
 * Once the <code>ui5-radio-button</code> is on focus, it might be selected by pressing the Space and Enter keys.
 * <br>
 * The Arrow Down/Arrow Up and Arrow Left/Arrow Right keys can be used to change selection between next/previous radio buttons in one group,
 * while TAB and SHIFT + TAB can be used to enter or leave the radio button group.
 * <br>
 * <b>Note:</b> On entering radio button group, the focus goes to the currently selected radio button.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/RadioButton";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.RadioButton
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-radio-button
 * @public
 */
declare class RadioButton extends UI5Element implements IFormElement {
    /**
     * Defines whether the component is disabled.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.RadioButton.prototype.disabled
     * @public
     */
    disabled: boolean;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.RadioButton.prototype.readonly
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is required.
     *
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.RadioButton.prototype.required
     * @public
     * @since 1.9.0
     */
    required: boolean;
    /**
     * Defines whether the component is checked or not.
     * <br><br>
     * <b>Note:</b> The property value can be changed with user interaction,
     * either by clicking/tapping on the component,
     * or by using the Space or Enter key.
     *
     * @type {boolean}
     * @defaultvalue false
     * @formEvents change
     * @formProperty
     * @name sap.ui.webc.main.RadioButton.prototype.checked
     * @public
     * @since 1.0.0-rc.15
     */
    checked: boolean;
    /**
     * Defines the text of the component.
     *
     * @type  {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.RadioButton.prototype.text
     * @public
     */
    text: string;
    /**
     * Defines the value state of the component.
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @defaultvalue "None"
     * @name sap.ui.webc.main.RadioButton.prototype.valueState
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines the name of the component.
     * Radio buttons with the same <code>name</code> will form a radio button group.
     *
     * <br><br>
     * <b>Note:</b>
     * The selection can be changed with <code>ARROW_UP/DOWN</code> and <code>ARROW_LEFT/RIGHT</code> keys between radio buttons in same group.
     *
     * <br><br>
     * <b>Note:</b>
     * Only one radio button can be selected per group.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect when submitting forms, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.RadioButton.prototype.name
     * @public
     */
    name: string;
    /**
     * Defines the form value of the component.
     * When a form with a radio button group is submitted, the group's value
     * will be the value of the currently selected radio button.
     * <br>
     * <b>Important:</b> For the <code>value</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.RadioButton.prototype.value
     * @public
     */
    value: string;
    /**
     * Defines whether the component text wraps when there is not enough space.
     * <br><b>Note:</b> for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * @type {sap.ui.webc.main.types.WrappingType}
     * @defaultvalue "None"
     * @name sap.ui.webc.main.RadioButton.prototype.wrappingType
     * @public
     */
    wrappingType: `${WrappingType}`;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.RadioButton.prototype.accessibleName
     * @public
     * @since 1.6.0
     */
    accessibleName: string;
    /**
     * Defines the IDs of the elements that label the component.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.RadioButton.prototype.accessibleNameRef
     * @public
     * @since 1.1.0
     */
    accessibleNameRef: string;
    _tabIndex: string;
    /**
     * Defines the active state (pressed or not) of the component.
     * @defaultvalue false
     * @private
     */
    active: boolean;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    _deactivate: () => void;
    _name: string;
    _checked: boolean;
    _internals: ElementInternals;
    static get formAssociated(): boolean;
    static i18nBundle: I18nBundle;
    constructor();
    static onDefine(): Promise<void>;
    onBeforeRendering(): void;
    onExitDOM(): void;
    syncGroup(forceRemove?: boolean): void;
    _enableFormSupport(): void;
    _setFormValue(): void;
    _resetFormValidity(): void;
    _invalidateForm(): void;
    _onclick(): this;
    _handleDown(e: KeyboardEvent): void;
    _handleUp(e: KeyboardEvent): void;
    _onkeydown(e: KeyboardEvent): void | this;
    _onkeyup(e: KeyboardEvent): void;
    _onmousedown(): void;
    _onmouseup(): void;
    _onfocusout(): void;
    toggle(): this;
    canToggle(): boolean;
    get classes(): {
        inner: {
            "ui5-radio-inner--hoverable": boolean;
        };
    };
    get effectiveAriaDisabled(): "true" | null;
    get ariaLabelText(): string;
    get effectiveAriaDescribedBy(): string | undefined;
    get hasValueState(): boolean;
    get valueStateText(): string;
    get radioButtonGroupRequiredText(): string;
    get effectiveTabIndex(): string;
    get strokeWidth(): "1" | "2";
}
export default RadioButton;
