import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/favorite.js";
import "@ui5/webcomponents-icons/dist/unfavorite.js";
type Star = {
    selected: boolean;
    index: number;
    halfStar: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The Rating Indicator is used to display a specific number of icons that are used to rate an item.
 * Additionally, it is also used to display the average and overall ratings.
 *
 * <h3>Usage</h3>
 * The recommended number of icons is between 5 and 7.
 *
 * <h3>Responsive Behavior</h3>
 * You can change the size of the Rating Indicator by changing its <code>font-size</code> CSS property.
 * <br>
 * Example: <code>&lt;ui5-rating-indicator style="font-size: 3rem;">&lt;/ui5-rating-indicator></code>
 *
 * <h3>Keyboard Handling</h3>
 * When the <code>ui5-rating-indicator</code> is focused, the user can change the rating
 * with the following keyboard shortcuts:
 * <br>
 *
 * <ul>
 * <li>[RIGHT/UP] - Increases the value of the rating by one step. If the highest value is reached, does nothing</li>
 * <li>[LEFT/DOWN] - Decreases the value of the rating by one step. If the lowest value is reached, does nothing.</li>
 * <li>[HOME] - Sets the lowest value.</li>
 * <li>[END] - Sets the highest value.</li>
 * <li>[SPACE/ENTER/RETURN] - Increases the value of the rating by one step. If the highest value is reached, sets the rating to the lowest value.</li>
 * <li>Any number - Changes value to the corresponding number. If typed number is larger than the number of values, sets the highest value.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/RatingIndicator.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.RatingIndicator
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-rating-indicator
 * @public
 * @since 1.0.0-rc.8
 */
declare class RatingIndicator extends UI5Element {
    /**
     * The indicated value of the rating.
     * <br><br>
     * <b>Note:</b> If you set a number which is not round, it would be shown as follows:
     * <ul>
     * <li>1.0 - 1.2 -> 1</li>
     * <li>1.3 - 1.7 -> 1.5</li>
     * <li>1.8 - 1.9 -> 2</li>
     * <ul>
     * @type {sap.ui.webc.base.types.Float}
     * @name sap.ui.webc.main.RatingIndicator.prototype.value
     * @defaultvalue 0
     * @public
     */
    value: number;
    /**
     * The number of displayed rating symbols.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.RatingIndicator.prototype.max
     * @defaultvalue 5
     * @public
     * @since 1.0.0-rc.15
     */
    max: number;
    /**
     * Defines whether the component is disabled.
     *
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     * @type {boolean}
     * @name sap.ui.webc.main.RatingIndicator.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.RatingIndicator.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.RatingIndicator.prototype.accessibleName
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.RatingIndicator.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.15.0
     */
    accessibleNameRef: string;
    /**
    * Defines whether the component is required.
    *
    * @type {boolean}
    * @name sap.ui.webc.main.RatingIndicator.prototype.required
    * @defaultvalue false
    * @public
    * @since 1.15.0
    */
    required: boolean;
    /**
     * Defines the tooltip of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.RatingIndicator.prototype.tooltip
     * @defaultvalue ""
     * @public
     * @since 1.19.0
     */
    tooltip: string;
    /**
     * @private
     */
    _stars: Array<Star>;
    /**
     * @private
     */
    _focused: boolean;
    _liveValue?: number;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    calcState(): void;
    _onclick(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onfocusin(): void;
    _onfocusout(): void;
    get effectiveTabIndex(): string;
    get ratingTooltip(): string;
    get defaultTooltip(): string;
    get _ariaRoleDescription(): string;
    get _ariaDisabled(): true | undefined;
    get _ariaLabel(): string | undefined;
    get _ariaDescription(): string | undefined;
    get ariaReadonly(): "true" | undefined;
}
export default RatingIndicator;
