import type { IOption } from "./Select.js";
import CustomListItem from "./CustomListItem.js";
import ListItemType from "./types/ListItemType.js";
import type { AccessibilityAttributes } from "./ListItem.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-select-menu-option</code> component represents an option in the <code>ui5-select-menu</code>.
 *
 * <h3>Usage</h3>
 *
 * For the <code>ui5-select-menu-option</code>
 * <h3>ES6 Module Import</h3>
 *
 * <code>import @ui5/webcomponents/dist/SelectMenuOption.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SelectMenuOption
 * @extends sap.ui.webc.main.CustomListItem
 * @implements sap.ui.webc.main.ISelectMenuOption
 * @tagname ui5-select-menu-option
 * @public
 * @since 1.17.0
 */
declare class SelectMenuOption extends CustomListItem implements IOption {
    /**
     * Defines the text, displayed inside the <code>ui5-select</code> input filed
     * when the option gets selected.
     *
     * @type {string}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.displayText
     * @public
     */
    displayText: string;
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is hidden.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.SelectMenuOption.prototype.disabled
     * @public
     */
    disabled: boolean;
    /**
     * Defines the value of the <code>ui5-select</code> inside an HTML Form element when this component is selected.
     * For more information on HTML Form support, see the <code>name</code> property of <code>ui5-select</code>.
     *
     * @type {string}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.value
     * @public
     */
    value: string;
    /**
     * <b>Note:</b> The property is inherited and not supported. If set, it won't take any effect.
     *
     * @type {sap.ui.webc.main.types.ListItemType}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.type
     * @defaultvalue "Active"
     * @public
     * @deprecated
     */
    type: `${ListItemType}`;
    /**
     * <b>Note:</b> The property is inherited and not supported. If set, it won't take any effect.
     *
     * @type {object}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.accessibilityAttributes
     * @public
     * @deprecated
     */
    accessibilityAttributes: AccessibilityAttributes;
    /**
     * <b>Note:</b> The property is inherited and not supported. If set, it won't take any effect.
     *
     * @public
     * @type {boolean}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.navigated
     * @deprecated
     */
    navigated: boolean;
    /**
     * Defines the content of the component.
     * <br><br>
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.SelectMenuOption.prototype.default
     * @slot
     * @public
     */
    /**
     * <b>Note:</b> The slot is inherited and not supported. If set, it won't take any effect.
     *
     * @name sap.ui.webc.main.SelectMenuOption.prototype.deleteButton
     * @type {Node[]}
     * @slot
     * @public
     * @deprecated
     */
    get _accInfo(): {
        ariaSelected: boolean;
        role: string;
        ariaExpanded?: boolean | undefined;
        ariaLevel?: number | undefined;
        ariaLabel: string;
        ariaLabelRadioButton: string;
        ariaSelectedText?: string | undefined;
        ariaHaspopup?: "Dialog" | "Grid" | "ListBox" | "Menu" | "Tree" | undefined;
        posinset?: number | undefined;
        setsize?: number | undefined;
        ariaChecked?: boolean | undefined;
        listItemAriaLabel?: string | undefined;
        ariaOwns?: string | undefined;
    };
}
export default SelectMenuOption;
