var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import StandardListItem from "./StandardListItem.js";
import SuggestionListItemTemplate from "./generated/templates/SuggestionListItemTemplate.lit.js";
/**
 * @class
 * The <code>ui5-li-suggestion-item</code> represents the suggestion item in the <code>ui5-input</code>
 * suggestion popover.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-li-suggestion-item</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>title - Used to style the title of the suggestion list item</li>
 * <li>description - Used to style the description of the suggestion list item</li>
 * <li>info - Used to style the info of the suggestion list item</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SuggestionListItem
 * @extends sap.ui.webc.main.StandardListItem
 * @tagname ui5-li-suggestion-item
 */
let SuggestionListItem = class SuggestionListItem extends StandardListItem {
    onBeforeRendering() {
        super.onBeforeRendering();
        this.hasTitle = !!this.titleText.length;
    }
    get effectiveTitle() {
        return this.titleText.filter(node => node.nodeType !== Node.COMMENT_NODE).map(el => el.textContent).join("");
    }
    get hasDescription() {
        return this.richDescription.length || this.description;
    }
    get groupItem() {
        return false;
    }
};
__decorate([
    slot({ type: HTMLElement })
], SuggestionListItem.prototype, "richDescription", void 0);
__decorate([
    slot({ type: Node, "default": true })
], SuggestionListItem.prototype, "titleText", void 0);
SuggestionListItem = __decorate([
    customElement({
        tag: "ui5-li-suggestion-item",
        template: SuggestionListItemTemplate,
    })
], SuggestionListItem);
SuggestionListItem.define();
export default SuggestionListItem;
//# sourceMappingURL=SuggestionListItem.js.map