import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ITab } from "./TabContainer.js";
import TabSeparatorInStripTemplate from "./generated/templates/TabSeparatorInStripTemplate.lit.js";
import TabSeparatorInOverflowTemplate from "./generated/templates/TabSeparatorInOverflowTemplate.lit.js";
/**
 * @class
 * The <code>ui5-tab-separator</code> represents a vertical line to separate tabs inside a <code>ui5-tabcontainer</code>.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TabSeparator
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-tab-separator
 * @implements sap.ui.webc.main.ITab
 * @public
 */
declare class TabSeparator extends UI5Element implements ITab {
    _getElementInStrip?: () => ITab | null;
    static get stripTemplate(): typeof TabSeparatorInStripTemplate;
    static get overflowTemplate(): typeof TabSeparatorInOverflowTemplate;
    get classes(): {
        root: {
            "ui5-tc__separator": boolean;
        };
    };
    get isSeparator(): boolean;
    /**
     * Returns the DOM reference of the separator that is placed in the header.
     * <b>Note:</b> Tabs and separators, placed in the <code>subTabs</code> slot of other tabs are not shown in the header. Calling this method on such tabs or separators will return <code>null</code>.
     *
     * @function
     * @public
     * @name sap.ui.webc.main.TabSeparator.prototype.getTabInStripDomRef
     */
    getTabInStripDomRef(): ITab | null;
    get stableDomRef(): string;
    get stripPresentation(): object;
    get overflowPresentation(): object;
}
export default TabSeparator;
