import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table-cell</code> component defines the structure of the data in a single <code>ui5-table</code> cell.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-table-cell</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>cell - Used to style the native <code>td</code> element</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TableCell
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table-cell
 * @implements sap.ui.webc.main.ITableCell
 * @public
 */
declare class TableCell extends UI5Element {
    /**
     * @private
     */
    lastInRow: boolean;
    /**
     * @private
     */
    popined: boolean;
    /**
     * @private
     */
    _popinedInline: boolean;
    /**
     * Specifies the content of the component.
     *
     * @type {Node[]}
     * @slot
     * @name sap.ui.webc.main.TableCell.prototype.default
     * @public
     */
    content?: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    get cellContent(): Array<HTMLElement>;
    get ariaLabelEmptyCellText(): string;
}
export default TableCell;
