var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var TableGroupRow_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import event from "@ui5/webcomponents-base/dist/decorators/event.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import { getI18nBundle } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import CheckBox from "./CheckBox.js";
import TableGroupRowTemplate from "./generated/templates/TableGroupRowTemplate.lit.js";
import TableMode from "./types/TableMode.js";
// Texts
import { TABLE_GROUP_ROW_ARIA_LABEL, } from "./generated/i18n/i18n-defaults.js";
// Styles
import tableGroupRowStyles from "./generated/themes/TableGroupRow.css.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table-group-row</code> component represents a group row in the <code>ui5-table</code>.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-table-group-row</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>group-row - Used to style the native <code>tr</code> element.</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TableGroupRow
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table-group-row
 * @since 1.0.0-rc.15
 * @implements sap.ui.webc.main.ITableRow
 * @public
 */
let TableGroupRow = TableGroupRow_1 = class TableGroupRow extends UI5Element {
    constructor() {
        super(...arguments);
        // Properties, set and handled by the Table
        this.selected = false;
        this._tabbables = [];
        this._columnsInfoString = "";
    }
    get colSpan() {
        return this._colSpan;
    }
    get ariaLabelText() {
        return `${TableGroupRow_1.i18nBundle.getText(TABLE_GROUP_ROW_ARIA_LABEL)} ${this.innerText}. ${this._ariaPosition}`;
    }
    visibleColCount() {
        let count = this._columnsInfo.reduce((acc, column) => {
            return column.visible ? ++acc : acc;
        }, 0);
        if (this.mode === TableMode.MultiSelect) {
            count++;
        }
        return count;
    }
    onBeforeRendering() {
        if (!this._columnsInfo || this._columnsInfo.length === 0) {
            return;
        }
        this._colSpan = this.visibleColCount();
    }
    _onfocusin(e) {
        this.fireEvent("_focused", e);
    }
    static async onDefine() {
        TableGroupRow_1.i18nBundle = await getI18nBundle("@ui5/webcomponents");
    }
};
__decorate([
    property({ type: TableMode, defaultValue: TableMode.None })
], TableGroupRow.prototype, "mode", void 0);
__decorate([
    property({ type: Object, multiple: true })
], TableGroupRow.prototype, "_columnsInfo", void 0);
__decorate([
    property({ defaultValue: "-1" })
], TableGroupRow.prototype, "_tabIndex", void 0);
__decorate([
    property({ type: Boolean })
], TableGroupRow.prototype, "_busy", void 0);
__decorate([
    property({ defaultValue: "", noAttribute: true })
], TableGroupRow.prototype, "_ariaPosition", void 0);
TableGroupRow = TableGroupRow_1 = __decorate([
    customElement({
        tag: "ui5-table-group-row",
        styles: tableGroupRowStyles,
        renderer: litRender,
        template: TableGroupRowTemplate,
        dependencies: [
            CheckBox,
        ],
    }),
    event("_focused")
], TableGroupRow);
TableGroupRow.define();
export default TableGroupRow;
//# sourceMappingURL=TableGroupRow.js.map