import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
import TimePickerInternals from "./TimePickerInternals.js";
import TimePickerClock from "./TimePickerClock.js";
import ToggleSpinButton from "./ToggleSpinButton.js";
import type { TimePickerClockChangeEventDetail } from "./TimePickerClock.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-time-selection-clocks</code> is component that contains all the <code>ui5-time-picker-clock</code> components
 * necessary for the <code>ui5-time-picker</code> as well as all necessary <code>ui5-toggle-spin-button</code> components
 * used for switching between different clocks.
 * <code>ui5-time-picker-clock</code> components and <code>ui5-toggle-spin-button</code> depend on the time format set to
 * <code>ui5-time-picker</code> component.
 *
 * This component should not be used separately.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TimeSelectionClocks
 * @extends sap.ui.webc.main.TimePickerInternals
 * @abstract
 * @tagname ui5-time-selection-clocks
 * @since 1.15.0
 * @private
 */
declare class TimeSelectionClocks extends TimePickerInternals {
    /**
     * Flag for pressed Space key
     */
    _spacePressed: boolean;
    onBeforeRendering(): void;
    /**
     * Returns ToggleSpinButton component by index or name.
     *
     * @param {number | string} indexOrName the index or name of the component
     * @returns { ToggleSpinButton | undefined} component (if exists) or undefined
     */
    _buttonComponent(indexOrName: number | string): ToggleSpinButton | null | undefined;
    /**
     * Returns TimePickerClock component by index or name.
     *
     * @param {number | string} indexOrName the index or name of the component
     * @returns { TimePickerClock | undefined} component (if exists) or undefined
     */
    _clockComponent(indexOrName: number | string): TimePickerClock | null | undefined;
    /**
     * TimePickerClocks focusin event handler. Focuses the active button and switches to active clock.
     *
     * @param {event} evt Event object
     */
    _clocksFocusIn(evt: Event): void;
    /**
     * ToggleSpinButton focusin event handler.Switches to clock which button is being focused.
     *
     * @param {event} evt Event object
     */
    _buttonFocusIn(evt: Event): void;
    /**
     * keyup event handler.
     *
     * @param {event} evt Event object
     */
    _onkeyup(evt: KeyboardEvent): void;
    /**
     * keydown event handler.
     *
     * @param {event} evt Event object
     */
    _onkeydown(evt: KeyboardEvent): void;
    /**
     * Handles direct numbers entry.
     *
     * @param {event} evt Event object
     */
    _numbersInput(evt: KeyboardEvent): void;
    /**
     * Focuses the first available button.
     */
    _focusFirstButton(): void;
    /**
     * Sets the exact match value. Must be overriden.
     */
    _setExactMatch(): void;
    /**
     * Creates clock and button components according to the display format pattern.
     */
    _createComponents(): void;
    /**
     * Switches to the specific clock by name.
     *
     * @param {string} clockName the name of the clock
     */
    _switchTo(clockName: string): void;
    /**
     * Switches to the specific clock by its index in _clocks property.
     *
     * @param {number} clockIndex the index of the clock
     */
    _switchClock(clockIndex: number): void;
    /**
     * Switches to the next available clock.
     *
     * @param {boolean} wrapAround whether to switch to the first clock if there are no next clock
     */
    _switchNextClock(wrapAround?: boolean): void;
    /**
     * Clock 'change' event handler.
     *
     * @param {event} evt Event object
     */
    _clockChange(evt: CustomEvent<TimePickerClockChangeEventDetail>): void;
}
export default TimeSelectionClocks;
