import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
import TimePickerInternals from "./TimePickerInternals.js";
import Input from "./Input.js";
import InputType from "./types/InputType.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-time-selection-inputs</code> displays a popover with <code>ui5-input</code> components of type="number" and an
 * optional a AM/PM <code>ui5-segmented-button</code> according to the display format given to the <code>ui5-time-picker</code>.
 * Using of numeric input components enables display of mobile devices' native numeric keyboard, which speeds up entering of the time.
 * The popup appears only on mobile devices when there is a tap on the <code>ui5-time-picker</code> input.
 *
 * This component should not be used separately.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TimeSelectionInputs
 * @extends sap.ui.webc.main.TimePickerInternals
 * @abstract
 * @tagname ui5-time-selection-inputs
 * @since 1.18.0
 * @private
 */
declare class TimeSelectionInputs extends TimePickerInternals {
    _editedInput: number;
    _editedInputValue: string;
    get enterHoursLabel(): string;
    get enterMinutesLabel(): string;
    get enterSecondsLabel(): string;
    get _numberType(): InputType;
    get _isHoursInput(): boolean;
    get _is24HoursFormat(): boolean;
    onBeforeRendering(): void;
    _addNumericAttributes(): void;
    /**
     * Returns Input component by index or name.
     *
     * @param {number | string} indexOrName the index or name of the component
     * @returns { Input | undefined} component (if exists) or undefined
     */
    _inputComponent(indexOrName: number | string): Input | null | undefined;
    /**
     * Returns the inner input element DOM reference.
     *
     * @param { Input } input the Input component
     * @returns { HTMLElement } inner input element
     */
    _innerInput(input: Input): HTMLInputElement | null;
    /**
     * Creates clock and button components according to the display format pattern.
     */
    _createComponents(): void;
    /**
     * Switches to the specific input.
     *
     * @param {number} index the index (in _entities array) of the input
     * @private
     */
    _switchInput(index: number): void;
    /**
     * Switches to the next input that can de focused.
     *
     * @param {boolean} wrapAround whether to start with first clock after reaching the last one, or not
     * @private
     */
    _switchNextInput(wrapAround?: boolean): void;
    /**
     * Return a value as string, formatted and prepended with zero if necessary.
     *
     * @param {number} num A number to format
     * @param {boolean} prependZero Whether to prepend with zero or not
     * @param {number} max Max value of the number for this clock
     * @returns {string} Formatted value
     * @private
     */
    _formatNumberToString(num: number, prependZero: boolean): string;
    _onkeydown(evt: KeyboardEvent): void;
    /**
     * Input 'change' event handler.
     *
     * @param {value} number new value to set on active input
     */
    _inputChange(value: number): void;
    _onfocusin(e: FocusEvent): void;
    _onfocusout(): void;
    _oninput(): void;
}
export default TimeSelectionInputs;
