import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import { TemplateFunction } from "@ui5/webcomponents-base/dist/renderer/executeTemplate.js";
import ToolbarItemOverflowBehavior from "./types/ToolbarItemOverflowBehavior.js";
type IEventOptions = {
    preventClosing: boolean;
};
interface IToolbarItem {
    overflowPriority: `${ToolbarItemOverflowBehavior}`;
    preventOverflowClosing: boolean;
    ignoreSpace?: boolean;
    isSeparator?: boolean;
    containsText?: boolean;
    hasFlexibleWidth?: boolean;
    stableDomRef: string;
}
/**
 * @class
 *
 * Represents an abstract class for items, used in the <code>ui5-toolbar</code>.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ToolbarItem
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @public
 * @since 1.17.0
 */
declare class ToolbarItem extends UI5Element implements IToolbarItem {
    /**
     * Property used to define the access of the item to the overflow Popover. If "NeverOverflow" option is set,
     * the item never goes in the Popover, if "AlwaysOverflow" - it never comes out of it.
     * Available options are:
     * <ul>
     * <li><code>NeverOverflow</code></li>
     * <li><code>AlwaysOverflow</code></li>
     * <li><code>Default</code></li>
     * </ul>
     * @public
     * @name sap.ui.webc.main.ToolbarItem.prototype.overflowPriority
     * @defaultvalue "Default"
     * @type {sap.ui.webc.main.types.ToolbarItemOverflowBehavior}
     */
    overflowPriority: `${ToolbarItemOverflowBehavior}`;
    /**
     * Defines if the toolbar overflow popup should close upon intereaction with the item.
     * It will close by default.
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.main.ToolbarItem.prototype.preventOverflowClosing
     */
    preventOverflowClosing: boolean;
    /**
    * Defines if the width of the item should be ignored in calculating the whole width of the toolbar
    * @returns {boolean}
    * @protected
    */
    get ignoreSpace(): boolean;
    /**
     * Returns if the item contains text. Used to position the text properly inside the popover.
     * Aligned left if the item has text, default aligned otherwise.
     * @protected
     * @returns {boolean}
     */
    get containsText(): boolean;
    /**
     * Returns if the item is flexible. An item that is returning true for this property will make
     * the toolbar expand to fill the 100% width of its container.
     * @protected
     * @returns {Boolean}
     */
    get hasFlexibleWidth(): boolean;
    /**
     * Returns if the item is interactive.
     * This value is used to determinate if the toolbar should have its accessibility role and attributes set.
     * At least two interactive items are needed for the toolbar to have the role="toolbar" attribute set.
     * @protected
     * @returns {boolean}
     */
    get isInteractive(): boolean;
    /**
     * Returns if the item is separator.
     * @protected
     * @returns {boolean}
     */
    get isSeparator(): boolean;
    /**
     * Returns the template for the toolbar item.
     * @protected
     * @returns {TemplateFunction}
     */
    static get toolbarTemplate(): TemplateFunction;
    /**
     * Returns the template for the toolbar item popover.
     * @protected
     * @returns {TemplateFunction}
     */
    static get toolbarPopoverTemplate(): TemplateFunction;
    /**
     * Returns the events that the item is subscribed to.
     * @protected
     * @returns {Map}
     */
    get subscribedEvents(): Map<string, IEventOptions>;
    get stableDomRef(): string;
}
export type { IToolbarItem, IEventOptions, };
export default ToolbarItem;
