import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import ToolbarSelectTemplate from "./generated/templates/ToolbarSelectTemplate.lit.js";
import ToolbarPopoverSelectTemplate from "./generated/templates/ToolbarPopoverSelectTemplate.lit.js";
import ToolbarItem from "./ToolbarItem.js";
import Option from "./Option.js";
import "./ToolbarSelectOption.js";
import type { SelectChangeEventDetail } from "./Select.js";
type ToolbarSelectChangeEventDetail = SelectChangeEventDetail;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-toolbar-select</code> component is used to create a toolbar drop-down list.
 * The items inside the <code>ui5-toolbar-select</code> define the available options by using the <code>ui5-toolbar-select-option</code> component.
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents/dist/ToolbarSelect";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/ToolbarSelectOption";</code> (comes with <code>ui5-toolbar-select</code>)
 * @constructor
 * @abstract
 * @author SAP SE
 * @alias sap.ui.webc.main.ToolbarSelect
 * @extends sap.ui.webc.main.ToolbarItem
 * @tagname ui5-toolbar-select
 * @appenddocs sap.ui.webc.main.ToolbarSelectOption
 * @public
 * @implements sap.ui.webc.main.IToolbarItem
 * @since 1.17.0
 */
declare class ToolbarSelect extends ToolbarItem {
    /**
     * Defines the width of the select.
     * <br><br>
     *
     * <b>Note:</b> all CSS sizes are supported - 'percentage', 'px', 'rem', 'auto', etc.
     *
     * @name sap.ui.webc.main.ToolbarSelect.prototype.width
     * @defaultvalue undefined
     * @type { sap.ui.webc.base.types.CSSSize }
     * @public
     */
    width?: string;
    /**
     * Defines the component options.
     *
     * <br><br>
     * <b>Note:</b> Only one selected option is allowed.
     * If more than one option is defined as selected, the last one would be considered as the selected one.
     *
     * <br><br>
     * <b>Note:</b> Use the <code>ui5-toolbar-select-option</code> component to define the desired options.
     * @type {sap.ui.webc.main.ISelectOption[]}
     * @slot options
     * @name sap.ui.webc.main.ToolbarSelect.prototype.default
     * @public
     */
    options: Array<Option>;
    /**
     * Defines the value state of the component.
     * <br><br>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @defaultvalue "None"
     * @name sap.ui.webc.main.ToolbarSelect.prototype.valueState
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is noninteractive.
     *
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.ToolbarSelect.prototype.disabled
     * @public
     */
    disabled: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @public
     * @defaultvalue ""
     * @name sap.ui.webc.main.ToolbarSelect.prototype.accessibleName
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the select.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.ToolbarSelect.prototype.accessibleNameRef
     * @public
     */
    accessibleNameRef: string;
    _onEvent: EventListener;
    static get toolbarTemplate(): typeof ToolbarSelectTemplate;
    static get toolbarPopoverTemplate(): typeof ToolbarPopoverSelectTemplate;
    get subscribedEvents(): Map<any, any>;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    attachEventListeners(): void;
    detachEventListeners(): void;
    _onEventHandler(e: Event): void;
    get styles(): {
        width: string | undefined;
    };
}
export default ToolbarSelect;
export type { ToolbarSelectChangeEventDetail, };
