import ToolbarSpacerTemplate from "./generated/templates/ToolbarSpacerTemplate.lit.js";
import ToolbarItem from "./ToolbarItem.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-toolbar-spacer</code> is an element, used for taking needed space for toolbar items to take 100% width.
 * It takes no space in calculating toolbar items width.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ToolbarSpacer
 * @extends sap.ui.webc.main.ToolbarItem
 * @tagname ui5-toolbar-spacer
 * @abstract
 * @since 1.17.0
 * @implements sap.ui.webc.main.IToolbarItem
 * @public
 */
declare class ToolbarSpacer extends ToolbarItem {
    /**
     * Defines the width of the spacer.
     * <br><br>
     *
     * <b>Note:</b> all CSS sizes are supported - 'percentage', 'px', 'rem', 'auto', etc.
     *
     * @public
     * @type { sap.ui.webc.base.types.CSSSize }
     * @name sap.ui.webc.main.ToolbarSpacer.prototype.width
     * @defaultvalue undefined
     */
    width?: string;
    get styles(): {
        width: string;
        flex?: undefined;
    } | {
        flex: string;
        width?: undefined;
    };
    get ignoreSpace(): boolean;
    get hasFlexibleWidth(): boolean;
    static get toolbarTemplate(): typeof ToolbarSpacerTemplate;
    static get toolbarPopoverTemplate(): typeof ToolbarSpacerTemplate;
    get isInteractive(): boolean;
}
export default ToolbarSpacer;
