import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import ListItem from "./ListItem.js";
import "@ui5/webcomponents-icons/dist/navigation-right-arrow.js";
import "@ui5/webcomponents-icons/dist/navigation-down-arrow.js";
import HasPopup from "./types/HasPopup.js";
type TreeItemBaseEventDetail = {
    item: TreeItemBase;
};
type TreeItemBaseToggleEventDetail = TreeItemBaseEventDetail;
type TreeItemBaseStepInEventDetail = TreeItemBaseEventDetail;
type TreeItemBaseStepOutEventDetail = TreeItemBaseEventDetail;
/**
 * A class to serve as a foundation
 * for the <code>TreeItem</code> and <code>TreeItemCustom</code> classes.
 *
 * @abstract
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TreeItemBase
 * @extends sap.ui.webc.main.ListItem
 * @public
 */
declare class TreeItemBase extends ListItem {
    /**
     * Defines the indentation of the tree list item. Use level 1 for tree list items, representing top-level tree nodes.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.TreeItemBase.prototype.level
     * @protected
     * @defaultValue 1
     */
    level: number;
    /**
     * If set, an icon will be displayed before the text of the tree list item.
     *
     * @public
     * @name sap.ui.webc.main.TreeItemBase.prototype.icon
     * @type {string}
     * @defaultValue ""
     */
    icon: string;
    /**
     * Defines whether the tree list item should display an expand/collapse button.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TreeItemBase.prototype.showToggleButton
     * @defaultvalue false
     * @protected
     */
    showToggleButton: boolean;
    /**
     * Defines whether the tree list item will show a collapse or expand icon inside its toggle button.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TreeItemBase.prototype.expanded
     * @defaultvalue false
     * @public
     */
    expanded: boolean;
    /**
    * Defines whether the selection of a tree node is displayed as partially selected.
    * <br><br>
    * <b>Note:</b> The indeterminate state can be set only programmatically and can’t be achieved by user
    * interaction, meaning that the resulting visual state depends on the values of the <code>indeterminate</code>
    * and <code>selected</code> properties:
    * <ul>
    * <li> If a tree node has both <code>selected</code> and <code>indeterminate</code> set to <code>true</code>, it is displayed as partially selected.
    * <li> If a tree node has <code>selected</code> set to <code>true</code> and <code>indeterminate</code> set to <code>false</code>, it is displayed as selected.
    * <li> If a tree node has <code>selected</code> set to <code>false</code>, it is displayed as not selected regardless of the value of the <code>indeterminate</code> property.
    * </ul>
    * <br>
    * <b>Note:</b> This property takes effect only when the <code>ui5-tree</code> is in <code>MultiSelect</code> mode.
    * @type {boolean}
    * @name sap.ui.webc.main.TreeItemBase.prototype.indeterminate
    * @defaultvalue false
    * @public
    * @since 1.1.0
    */
    indeterminate: boolean;
    /**
     * Defines whether the tree node has children, even if currently no other tree nodes are slotted inside.
     * <br>
     * <i>Note:</i> This property is useful for showing big tree structures where not all nodes are initially loaded due to performance reasons.
     * Set this to <code>true</code> for nodes you intend to load lazily, when the user clicks the expand button.
     * It is not necessary to set this property otherwise. If a tree item has children, the expand button will be displayed anyway.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TreeItemBase.prototype.hasChildren
     * @defaultvalue false
     * @public
     */
    hasChildren: boolean;
    /**
     * Defines the state of the <code>additionalText</code>.
     * <br>
     * Available options are: <code>"None"</code> (by default), <code>"Success"</code>, <code>"Warning"</code>, <code>"Information"</code> and <code>"Error"</code>.
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.TreeItemBase.prototype.additionalTextState
     * @defaultvalue "None"
     * @public
     * @since 1.0.0-rc.15
     */
    additionalTextState: `${ValueState}`;
    /**
     * Defines the accessible name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.TreeItemBase.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     * @since 1.8.0
     */
    accessibleName: string;
    /**
     * @private
     * @since 1.0.0-rc.11
     */
    _setsize: number;
    /**
     * @private
     * @since 1.0.0-rc.11
     */
    _posinset: number;
    /**
     * Defines the description for the accessible role of the component.
     * @protected
     * @type {string}
     * @defaultvalue undefined
     * @since 1.10.0
     */
    accessibleRoleDescription?: string;
    /**
     * Defines if the item should be collapsible or not.
     * @private
     * @type {boolean}
     * @defaultvalue false
     * @since 1.10.0
     */
    _fixed: boolean;
    /**
     * Defines the availability and type of interactive popup element that can be triggered by the component on which the property is set.
     * @type {sap.ui.webc.main.types.HasPopup}
     * @since 1.10.0
     * @private
     */
    ariaHaspopup?: `${HasPopup}`;
    /**
     * Defines the items of the component.
     * <br />
     * <br />
     * <b>Note:</b> Use <code>ui5-tree-item</code> or <code>ui5-tree-item-custom</code>
     *
     * @type {sap.ui.webc.main.ITreeItem[]}
     * @name sap.ui.webc.main.TreeItemBase.prototype.default
     * @slot items
     * @public
     */
    items: Array<TreeItemBase>;
    onBeforeRendering(): void;
    get classes(): ClassMap;
    get styles(): {
        preContent: {
            "padding-inline-start": string;
        };
    };
    get requiresToggleButton(): boolean;
    get effectiveLevel(): number;
    get hasParent(): boolean;
    get _toggleIconName(): "navigation-down-arrow" | "navigation-right-arrow";
    get _ariaLabel(): string | undefined;
    get _accInfo(): {
        role: string;
        ariaExpanded: boolean | undefined;
        ariaLevel: number;
        posinset: number;
        setsize: number;
        ariaSelectedText: string | undefined;
        listItemAriaLabel: string | undefined;
        ariaOwns: string | undefined;
        ariaHaspopup: "Dialog" | "Grid" | "ListBox" | "Menu" | "Tree" | undefined;
        ariaSelected: boolean;
        ariaLabel: string;
        ariaLabelRadioButton: string;
        ariaChecked?: boolean | undefined;
    };
    /**
     * Used to duck-type TreeItem elements without using instanceof
     * @returns {boolean}
     * @protected
     */
    get isTreeItem(): boolean;
    /**
     * Call this method to manually switch the <code>expanded</code> state of a tree item.
     * @public
     * @method
     * @name sap.ui.webc.main.TreeItemBase#toggle
     */
    toggle(): void;
    _toggleClick(e: MouseEvent | KeyboardEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    get iconAccessibleName(): string;
    static onDefine(): Promise<void>;
}
export default TreeItemBase;
export type { TreeItemBaseToggleEventDetail, TreeItemBaseStepInEventDetail, TreeItemBaseStepOutEventDetail, };
