import type UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import List from "../List.js";
import type { ListItemClickEventDetail, ListSelectionChangeEventDetail } from "../List.js";
import ResponsivePopover from "../ResponsivePopover.js";
import SuggestionItem from "../SuggestionItem.js";
import SuggestionGroupItem from "../SuggestionGroupItem.js";
import Button from "../Button.js";
import Icon from "../Icon.js";
import Popover from "../Popover.js";
import GroupHeaderListItem from "../GroupHeaderListItem.js";
import SuggestionListItem from "../SuggestionListItem.js";
import type ListItemType from "../types/ListItemType.js";
interface SuggestionComponent extends UI5Element {
    _isValueStateFocused: boolean;
    focused: boolean;
    hasSuggestionItemSelected: boolean;
    value: string;
    typedInValue: string;
    hasValueStateMessage: boolean;
    suggestionItems: Array<SuggestionItem>;
    open: boolean;
    onItemMouseOver: (e: MouseEvent) => void;
    onItemMouseOut: (e: MouseEvent) => void;
    onItemSelected: (pressedItem: SuggestionItem, keyboardUsed: boolean) => void;
    onItemPreviewed: (item: SuggestionListItem) => void;
}
type InputSuggestion = {
    text: string;
    description: string;
    image?: string;
    icon?: string;
    type: `${ListItemType}`;
    additionalText?: string;
    additionalTextState: `${ValueState}`;
    groupItem: boolean;
    key: number;
};
type SuggestionsAccInfo = {
    isGroup: boolean;
    currentPos: number;
    listSize: number;
    itemText: string;
    description: string;
    additionalText: string;
};
/**
 * A class to manage the <code>Input</code suggestion items.
 *
 * @class
 * @private
 * @author SAP SE
 */
declare class Suggestions {
    component: SuggestionComponent;
    slotName: string;
    handleFocus: boolean;
    highlight: boolean;
    selectedItemIndex: number;
    accInfo?: SuggestionsAccInfo;
    responsivePopover?: ResponsivePopover;
    _scrollContainer?: HTMLElement;
    _handledPress?: boolean;
    attachedAfterOpened?: boolean;
    attachedAfterClose?: boolean;
    fnOnSuggestionItemPress: (e: CustomEvent<ListItemClickEventDetail | ListSelectionChangeEventDetail>) => void;
    fnOnSuggestionItemMouseOver: (e: MouseEvent) => void;
    fnOnSuggestionItemMouseOut: (e: MouseEvent) => void;
    static i18nBundle: I18nBundle;
    static SCROLL_STEP: number;
    constructor(component: SuggestionComponent, slotName: string, highlight: boolean, handleFocus: boolean);
    defaultSlotProperties(hightlightValue: string): InputSuggestion[];
    onUp(e: KeyboardEvent): boolean;
    onDown(e: KeyboardEvent): boolean;
    onSpace(e: KeyboardEvent): boolean;
    onEnter(e: KeyboardEvent): boolean;
    onPageUp(e: KeyboardEvent): boolean;
    onPageDown(e: KeyboardEvent): boolean;
    onHome(e: KeyboardEvent): boolean;
    onEnd(e: KeyboardEvent): boolean;
    onTab(): boolean;
    toggle(bToggle: boolean, options: {
        preventFocusRestore: boolean;
    }): void;
    _isScrollable(): Promise<boolean>;
    open(): void;
    close(preventFocusRestore?: boolean): Promise<void>;
    updateSelectedItemPosition(pos: number): void;
    onItemMouseOver(e: MouseEvent): void;
    onItemMouseOut(e: MouseEvent): void;
    onItemSelected(selectedItem: SuggestionListItem | null, keyboardUsed: boolean): void;
    onItemPreviewed(item: SuggestionListItem): void;
    onItemPress(e: CustomEvent<ListItemClickEventDetail | ListSelectionChangeEventDetail>): void;
    _beforeOpen(): void;
    _attachItemsListeners(): Promise<void>;
    _attachPopupListeners(): void;
    _onOpen(): void;
    _onClose(): void;
    _applyFocus(): void;
    _isItemOnTarget(): boolean;
    get _isGroupOrInactiveItem(): boolean;
    isOpened(): boolean;
    _handleItemNavigation(forward: boolean): void;
    _selectNextItem(): void;
    _selectPreviousItem(): void;
    _moveItemSelection(previousIdx: number, nextIdx: number): void;
    _deselectItems(): void;
    _clearItemFocus(): void;
    _isItemIntoView(item: SuggestionListItem): boolean;
    _scrollItemIntoView(item: SuggestionListItem): Promise<void>;
    _getScrollContainer(): Promise<HTMLElement>;
    _getItems(): Array<SuggestionListItem>;
    _getNonGroupItems(): Array<SuggestionListItem>;
    _getComponent(): SuggestionComponent;
    _getList(): Promise<List>;
    _getListWidth(): Promise<number>;
    _getRealItems(): SuggestionItem[];
    _getSuggestionPopover(): Promise<ResponsivePopover>;
    get itemSelectionAnnounce(): string;
    getRowText(suggestion: SuggestionItem): string;
    getRowDesc(suggestion: SuggestionItem): string;
    getHighlightedText(suggestion: SuggestionItem, input: string): string;
    getHighlightedDesc(suggestion: SuggestionItem, input: string): string;
    hightlightInput(text: string, input: string): string;
    sanitizeText(text: string): string;
    get _hasValueState(): boolean;
    _focusValueState(): void;
    _clearValueStateFocus(): void;
    _clearSelectedSuggestionAndAccInfo(): void;
    static get dependencies(): (typeof Icon | typeof Button | typeof Popover | typeof List | typeof SuggestionListItem | typeof GroupHeaderListItem | typeof SuggestionGroupItem)[];
    static init(): Promise<void>;
}
export default Suggestions;
export type { SuggestionComponent, InputSuggestion, };
